/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.outline;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.outline.DocumentOutlinePage;

public class ToolBarToggleAction
extends Action {
    private final DocumentOutlinePage outlinePage;
    private final String commandId;

    public ToolBarToggleAction(DocumentOutlinePage outlinePage, String stateName, ImageDescriptor imageDescriptor) {
        super(Messages.getString("DocumentOutlinePage.action." + stateName + ".title"), 2);
        this.outlinePage = outlinePage;
        this.commandId = stateName;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        boolean isChecked = preferences.getBoolean(stateName, true);
        this.setChecked(isChecked);
        this.setToolTipText(Messages.getString("DocumentOutlinePage.action." + stateName + ".tooltip"));
        this.setDescription(Messages.getString("DocumentOutlinePage.action." + stateName + ".tooltip"));
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.vex.ui");
        preferences.putBoolean(this.commandId, this.isChecked());
        this.outlinePage.setViewState(this.commandId, this.isChecked());
    }
}

