/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.vex.core.provisional.dom.AttributeDefinition;
import org.eclipse.vex.core.provisional.dom.DocumentValidationException;
import org.eclipse.vex.core.provisional.dom.IAttribute;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.core.provisional.dom.IValidator;
import org.eclipse.vex.ui.internal.Messages;

public class ElementPropertySource
implements IPropertySource2 {
    private static final String ATTR_ID = "id";
    private static final String ELEMENT_NAME_PROPERTY = "elementName";
    private static final String ELEMENT_NAMESPACE_URI_PROPERTY = "elementNsUri";
    private static final String ELEMENT_NAMESPACE_PREFIX_PROPERTY = "elementNsPrefix";
    private static final String ELEMENT_CATEGORY = "Element";
    private static final String ATTRIBUTES_CATEGORY = "Attributes";
    private static final String NAMESPACES_CATEGORY = "Namespaces";
    private final IElement element;
    private final IValidator validator;
    private final boolean multipleElementsSelected;

    public ElementPropertySource(IElement element, IValidator validator, boolean multipleElementsSelected) {
        this.element = element;
        this.validator = validator;
        this.multipleElementsSelected = multipleElementsSelected;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.createExpertPropertyDescriptor(ELEMENT_NAME_PROPERTY, "Element Name", ELEMENT_CATEGORY));
        if (this.element.getQualifiedName().getQualifier() != null) {
            result.add(this.createExpertPropertyDescriptor(ELEMENT_NAMESPACE_URI_PROPERTY, "Namespace URI", ELEMENT_CATEGORY));
            result.add(this.createExpertPropertyDescriptor(ELEMENT_NAMESPACE_PREFIX_PROPERTY, "Namespace Prefix", ELEMENT_CATEGORY));
        }
        List attributeDefinitions = this.validator.getAttributeDefinitions(this.element);
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            String nsPrefix = this.element.getNamespacePrefix(attributeDefinition.getQualifiedName().getQualifier());
            String attributeName = attributeDefinition.getName();
            if (nsPrefix != null) {
                attributeName = String.valueOf(nsPrefix) + ":" + attributeName;
            }
            Object propertyDescriptor = this.multipleElementsSelected && attributeDefinition.getName().equals(ATTR_ID) ? new PropertyDescriptor((Object)attributeDefinition, attributeName) : (attributeDefinition.isFixed() ? new PropertyDescriptor((Object)attributeDefinition, attributeName) : (attributeDefinition.getType() == AttributeDefinition.Type.ENUMERATION ? new ComboBoxPropertyDescriptor((Object)attributeDefinition, attributeName, ElementPropertySource.getEnumValues(attributeDefinition)) : new TextPropertyDescriptor((Object)attributeDefinition, attributeName)));
            if (nsPrefix != null) {
                propertyDescriptor.setCategory("Attributes " + nsPrefix);
            } else {
                propertyDescriptor.setCategory(ATTRIBUTES_CATEGORY);
            }
            result.add(propertyDescriptor);
        }
        for (String namespacePrefix : this.element.getNamespacePrefixes()) {
            String namespaceUri = this.element.getNamespaceURI(namespacePrefix);
            NamespaceUri namespaceDeclaration = new NamespaceUri(namespaceUri);
            result.add(this.createExpertPropertyDescriptor(namespaceDeclaration, "xmlns:" + namespacePrefix, NAMESPACES_CATEGORY));
        }
        String defaultNamespaceUri = this.element.getDefaultNamespaceURI();
        if (defaultNamespaceUri != null) {
            NamespaceUri namespaceDeclaration = new NamespaceUri(defaultNamespaceUri);
            result.add(this.createExpertPropertyDescriptor(namespaceDeclaration, "xmlns", NAMESPACES_CATEGORY));
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    private IPropertyDescriptor createExpertPropertyDescriptor(Object id, String displayName, String category) {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(id, displayName);
        propertyDescriptor.setCategory(category);
        propertyDescriptor.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
        return propertyDescriptor;
    }

    public Object getPropertyValue(Object id) {
        if (id == ELEMENT_NAME_PROPERTY) {
            return this.element.getLocalName();
        }
        if (id == ELEMENT_NAMESPACE_URI_PROPERTY) {
            return this.element.getQualifiedName().getQualifier();
        }
        if (id == ELEMENT_NAMESPACE_PREFIX_PROPERTY) {
            return this.element.getNamespacePrefix(this.element.getQualifiedName().getQualifier());
        }
        if (id instanceof AttributeDefinition) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)id;
            if (this.multipleElementsSelected && id.equals(ATTR_ID)) {
                return Messages.getString("ElementPropertySource.multiple");
            }
            IAttribute attribute = this.element.getAttribute(attributeDefinition.getQualifiedName());
            String value = attribute != null ? attribute.getValue() : ElementPropertySource.nullToEmpty(attributeDefinition.getDefaultValue());
            if (attributeDefinition.getType() == AttributeDefinition.Type.ENUMERATION) {
                String[] values = ElementPropertySource.getEnumValues(attributeDefinition);
                int i = 0;
                while (i < values.length) {
                    if (values[i].equals(value)) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
            return value;
        }
        if (id instanceof NamespaceUri) {
            return ((NamespaceUri)id).uri;
        }
        return "";
    }

    private static String nullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public boolean isPropertySet(Object id) {
        if (id == ELEMENT_NAME_PROPERTY) {
            return true;
        }
        if (id == ELEMENT_NAMESPACE_URI_PROPERTY) {
            return true;
        }
        if (id == ELEMENT_NAMESPACE_PREFIX_PROPERTY) {
            return true;
        }
        if (id instanceof AttributeDefinition) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)id;
            IAttribute attribute = this.element.getAttribute(attributeDefinition.getName());
            return attribute != null;
        }
        return id instanceof NamespaceUri;
    }

    public void resetPropertyValue(Object id) {
        if (!(id instanceof AttributeDefinition)) {
            return;
        }
        AttributeDefinition attributeDefinition = (AttributeDefinition)id;
        this.element.removeAttribute(attributeDefinition.getName());
    }

    public void setPropertyValue(Object id, Object value) {
        if (!(id instanceof AttributeDefinition)) {
            return;
        }
        AttributeDefinition attributeDefinition = (AttributeDefinition)id;
        try {
            if (attributeDefinition.getType() == AttributeDefinition.Type.ENUMERATION) {
                int i = (Integer)value;
                String enumValue = ElementPropertySource.getEnumValues(attributeDefinition)[i];
                if (!attributeDefinition.isRequired() && enumValue.equals("")) {
                    this.element.removeAttribute(attributeDefinition.getName());
                } else {
                    this.element.setAttribute(attributeDefinition.getQualifiedName(), enumValue);
                }
            } else {
                String s = (String)value;
                if (s.equals("")) {
                    this.element.removeAttribute(attributeDefinition.getQualifiedName());
                } else {
                    this.element.setAttribute(attributeDefinition.getQualifiedName(), s);
                }
            }
        }
        catch (DocumentValidationException documentValidationException) {}
    }

    private static String[] getEnumValues(AttributeDefinition attributeDefinition) {
        String[] values = attributeDefinition.getValues();
        if (attributeDefinition.isRequired()) {
            return values;
        }
        if (values == null) {
            values = new String[]{""};
        }
        String[] values2 = new String[values.length + 1];
        values2[0] = "";
        System.arraycopy(values, 0, values2, 1, values.length);
        return values2;
    }

    public boolean isPropertyResettable(Object id) {
        return id instanceof AttributeDefinition;
    }

    private static class NamespaceUri {
        public final String uri;

        public NamespaceUri(String uri) {
            this.uri = uri;
        }
    }
}

