/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.swt;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vex.core.IValidationResult;
import org.eclipse.vex.core.XML;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.PluginImages;

public class ProcessingInstrDialog
extends TitleAreaDialog {
    private Text textTarget;
    private String target;
    private boolean targetValid = true;
    protected Color fgColor;

    public ProcessingInstrDialog(Shell shell) {
        this(shell, "");
    }

    public ProcessingInstrDialog(Shell shell, String target) {
        super(shell);
        this.setHelpAvailable(false);
        this.target = target;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("ProcessingInstrDialog.Title"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        Label lblTarget = new Label(container, 0);
        FormData fd_lblTarget = new FormData();
        fd_lblTarget.top = new FormAttachment(0, 10);
        fd_lblTarget.left = new FormAttachment(0, 10);
        lblTarget.setLayoutData((Object)fd_lblTarget);
        lblTarget.setText(Messages.getString("ProcessingInstrDialog.targetLabel"));
        this.textTarget = new Text(container, 2048);
        this.fgColor = this.textTarget.getForeground();
        this.textTarget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessingInstrDialog.this.evaluateTarget();
            }
        });
        FormData fd_textTarget = new FormData();
        fd_textTarget.right = new FormAttachment(100, -10);
        fd_textTarget.left = new FormAttachment((Control)lblTarget, 26);
        fd_textTarget.bottom = new FormAttachment(100, -10);
        fd_textTarget.top = new FormAttachment(0, 7);
        this.textTarget.setLayoutData((Object)fd_textTarget);
        return area;
    }

    public String getTarget() {
        return this.target;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.textTarget.setText(this.target);
    }

    protected Point getInitialSize() {
        return new Point(450, 185);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("ProcessingInstrDialog.DialogTitle"));
        shell.setImage(PluginImages.get("org.eclipse.vex.ui.img.vex_icon"));
    }

    protected void okPressed() {
        this.evaluateTarget();
        if (this.targetValid) {
            super.okPressed();
        }
    }

    private void evaluateTarget() {
        String text = this.textTarget.getText();
        IValidationResult resultTarget = XML.validateProcessingInstructionTarget((String)text);
        if (resultTarget.isOK()) {
            if (!this.targetValid) {
                this.targetValid = true;
                this.getButton(0).setEnabled(this.targetValid);
                this.setErrorMessage(null);
                this.textTarget.setForeground(this.fgColor);
                this.textTarget.redraw();
            }
            this.target = text;
        } else {
            this.targetValid = false;
            this.getButton(0).setEnabled(this.targetValid);
            this.setErrorMessage(text.isEmpty() ? null : resultTarget.getMessage());
            this.textTarget.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
            this.textTarget.redraw();
        }
    }
}

