/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.views;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.vex.core.internal.core.Caret;
import org.eclipse.vex.core.internal.core.Rectangle;
import org.eclipse.vex.core.internal.layout.Box;
import org.eclipse.vex.core.internal.widget.BaseVexWidget;
import org.eclipse.vex.core.internal.widget.IBoxFilter;
import org.eclipse.vex.core.internal.widget.IHostComponent;
import org.eclipse.vex.core.internal.widget.swt.VexWidget;
import org.eclipse.vex.core.provisional.dom.ContentPosition;
import org.eclipse.vex.core.provisional.dom.ContentRange;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.ui.internal.editor.VexEditor;

class DebugViewPage
implements IPageBookViewPage {
    private static final int X = 1;
    private static final int Y = 2;
    private static final int WIDTH = 3;
    private static final int HEIGHT = 4;
    private static Field implField;
    private static Field rootBoxField;
    private static Field caretField;
    private static Field hostComponentField;
    private static Method findInnermostBoxMethod;
    private IPageSite site;
    private final VexEditor vexEditor;
    private VexWidget vexWidget;
    private BaseVexWidget impl;
    private Composite composite;
    private Label loadingLabel;
    private Composite content;
    private Table table;
    private Table textTable;
    private TableItem documentItem;
    private TableItem viewportItem;
    private TableItem boxItem;
    private TableItem caretOffsetItem;
    private TableItem caretOffsetContentItem;
    private TableItem caretAbsItem;
    private TableItem caretRelItem;
    private TableItem mouseAbsItem;
    private TableItem mouseRelItem;
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (DebugViewPage.this.vexWidget == null) {
                DebugViewPage.this.createDebugPanel();
            }
            DebugViewPage.this.repopulate();
        }
    };
    private final ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            DebugViewPage.this.resizeTables();
        }
    };
    private final MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            Rectangle rect = new Rectangle(e.x, e.y, 0, 0);
            Rectangle viewport = DebugViewPage.this.getViewport();
            DebugViewPage.setItemFromRect(DebugViewPage.this.mouseAbsItem, rect);
            DebugViewPage.setItemRel(DebugViewPage.this.mouseRelItem, viewport, rect);
        }
    };

    static {
        try {
            implField = VexWidget.class.getDeclaredField("impl");
            implField.setAccessible(true);
            rootBoxField = BaseVexWidget.class.getDeclaredField("rootBox");
            rootBoxField.setAccessible(true);
            caretField = BaseVexWidget.class.getDeclaredField("caret");
            caretField.setAccessible(true);
            hostComponentField = BaseVexWidget.class.getDeclaredField("hostComponent");
            hostComponentField.setAccessible(true);
            findInnermostBoxMethod = BaseVexWidget.class.getDeclaredMethod("findInnermostBox", IBoxFilter.class);
            findInnermostBoxMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DebugViewPage(VexEditor vexEditor) {
        this.vexEditor = vexEditor;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        if (this.vexEditor.isLoaded()) {
            this.createDebugPanel();
        } else {
            this.loadingLabel = new Label(this.composite, 0);
            this.loadingLabel.setText("Loading...");
        }
        this.vexEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void dispose() {
        if (this.vexWidget != null && !this.vexWidget.isDisposed()) {
            this.vexWidget.removeMouseMoveListener(this.mouseMoveListener);
        }
        this.vexEditor.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }

    private void createDebugPanel() {
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
        this.vexWidget = this.vexEditor.getVexWidget();
        try {
            this.impl = (BaseVexWidget)implField.get(this.vexWidget);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        ScrolledComposite sc = new ScrolledComposite(this.composite, 512);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridDataFactory dataFactory = GridDataFactory.swtDefaults().align(4, 4).hint(-1, 50).grab(true, true);
        dataFactory.applyTo((Control)sc);
        this.content = new Composite((Composite)sc, 0);
        GridLayout contentLayout = new GridLayout(1, false);
        this.content.setLayout((Layout)contentLayout);
        sc.setContent((Control)this.content);
        this.table = new Table(this.content, 16);
        this.table.setHeaderVisible(true);
        GridData tableGrid = new GridData();
        tableGrid.grabExcessHorizontalSpace = true;
        tableGrid.horizontalAlignment = 4;
        this.table.setLayoutData((Object)tableGrid);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setText("Item");
        column = new TableColumn(this.table, 16384);
        column.setText("X");
        column = new TableColumn(this.table, 16384);
        column.setText("Y");
        column = new TableColumn(this.table, 131072);
        column.setText("Width");
        column = new TableColumn(this.table, 131072);
        column.setText("Height");
        this.documentItem = new TableItem(this.table, 0);
        this.documentItem.setText(0, "Document");
        this.viewportItem = new TableItem(this.table, 0);
        this.viewportItem.setText(0, "Viewport");
        this.caretAbsItem = new TableItem(this.table, 0);
        this.caretAbsItem.setText(0, "Caret Abs.");
        this.caretRelItem = new TableItem(this.table, 0);
        this.caretRelItem.setText(0, "Caret Rel.");
        this.mouseAbsItem = new TableItem(this.table, 0);
        this.mouseAbsItem.setText(0, "Mouse Abs.");
        this.mouseRelItem = new TableItem(this.table, 0);
        this.mouseRelItem.setText(0, "Mouse Rel.");
        this.textTable = new Table(this.content, 16);
        this.textTable.setHeaderVisible(true);
        GridData textTableGrid = new GridData();
        textTableGrid.grabExcessHorizontalSpace = true;
        textTableGrid.horizontalAlignment = 4;
        this.textTable.setLayoutData((Object)textTableGrid);
        this.textTable.setSize(this.textTable.computeSize(-1, 300));
        this.textTable.addControlListener(this.controlListener);
        column = new TableColumn(this.textTable, 16384);
        column.setText("Item");
        column = new TableColumn(this.textTable, 16384);
        column.setText("Value");
        this.caretOffsetItem = new TableItem(this.textTable, 0);
        this.caretOffsetItem.setText(0, "Caret Offset");
        this.boxItem = new TableItem(this.textTable, 0);
        this.boxItem.setText(0, "Current Box");
        this.caretOffsetContentItem = new TableItem(this.textTable, 0);
        this.caretOffsetContentItem.setText(0, "Content at Caret");
        this.content.setSize(this.content.computeSize(-1, -1));
        sc.setMinSize(this.content.computeSize(-1, -1));
        Button updateButton = new Button(this.composite, 8);
        updateButton.setText("Refresh");
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DebugViewPage.this.repopulate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.composite.layout();
        this.vexWidget.addMouseMoveListener(this.mouseMoveListener);
        this.repopulate();
    }

    private void resizeTables() {
        this.table.getColumn(0).pack();
        int width = this.table.getSize().x - this.table.getColumn(0).getWidth();
        int numWidth = Math.round(width / 4);
        this.table.getColumn(1).setWidth(numWidth);
        this.table.getColumn(2).setWidth(numWidth);
        this.table.getColumn(3).setWidth(numWidth);
        this.table.getColumn(4).setWidth(numWidth);
        this.textTable.getColumn(0).pack();
        width = this.textTable.getSize().x - this.textTable.getColumn(0).getWidth();
        this.textTable.getColumn(1).setWidth(width);
    }

    private Rectangle getCaretBounds() {
        Caret caret = (Caret)this.getFieldValue(caretField, this.impl);
        return caret.getBounds();
    }

    private Rectangle getRootBoxBounds() {
        Box rootBox = (Box)this.getFieldValue(rootBoxField, this.impl);
        return new Rectangle(rootBox.getX(), rootBox.getY(), rootBox.getWidth(), rootBox.getHeight());
    }

    private Rectangle getViewport() {
        IHostComponent hc = (IHostComponent)this.getFieldValue(hostComponentField, this.impl);
        return hc.getViewport();
    }

    private Object getFieldValue(Field field, Object o) {
        try {
            return field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void repopulate() {
        DebugViewPage.setItemFromRect(this.documentItem, this.getRootBoxBounds());
        DebugViewPage.setFromInnermostBox(this.boxItem, this.getInnermostBox());
        Rectangle viewport = this.getViewport();
        this.caretOffsetItem.setText(1, this.impl.getCaretPosition().toString());
        this.caretOffsetContentItem.setText(1, this.getContent());
        DebugViewPage.setItemFromRect(this.viewportItem, viewport);
        DebugViewPage.setItemFromRect(this.caretAbsItem, this.getCaretBounds());
        DebugViewPage.setItemRel(this.caretRelItem, viewport, this.getCaretBounds());
    }

    private static void setFromInnermostBox(TableItem item, Box innermostBox) {
        if (innermostBox == null) {
            item.setText(1, "n/a");
            return;
        }
        item.setText(1, String.valueOf(innermostBox.getClass().getSimpleName()) + ": " + innermostBox);
    }

    private Box getInnermostBox() {
        try {
            return (Box)findInnermostBoxMethod.invoke((Object)this.impl, IBoxFilter.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private String getContent() {
        ContentPosition offset = this.impl.getCaretPosition();
        IDocument doc = this.impl.getDocument();
        StringBuilder result = new StringBuilder();
        ContentRange range = new ContentRange(offset.moveBy(-8), offset.moveBy(8)).intersection(doc.getRange());
        String content = doc.getContent().getRawText(range);
        int caretIndex = offset.getOffset() - range.getStartOffset();
        result.append(content.substring(0, caretIndex).replace("\u0000", "#"));
        result.append("|");
        result.append(content.substring(caretIndex, content.length()).replace("\u0000", "#"));
        return result.toString();
    }

    private static void setItemFromRect(TableItem item, Rectangle rect) {
        item.setText(1, Integer.toString(rect.getX()));
        item.setText(2, Integer.toString(rect.getY()));
        item.setText(3, Integer.toString(rect.getWidth()));
        item.setText(4, Integer.toString(rect.getHeight()));
    }

    private static void setItemRel(TableItem item, Rectangle viewport, Rectangle rect) {
        item.setText(1, Integer.toString(rect.getX() - viewport.getX()));
        item.setText(2, Integer.toString(rect.getY() - viewport.getY()));
        item.setText(3, Integer.toString(rect.getWidth()));
        item.setText(4, Integer.toString(rect.getHeight()));
    }
}

