/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.vex.core.internal.css.CssWhitespacePolicy;
import org.eclipse.vex.core.internal.css.IWhitespacePolicy;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.core.internal.io.DocumentWriter;
import org.eclipse.vex.core.internal.validator.WTPVEXValidator;
import org.eclipse.vex.core.provisional.dom.DocumentContentModel;
import org.eclipse.vex.core.provisional.dom.IDocument;
import org.eclipse.vex.core.provisional.dom.IElement;
import org.eclipse.vex.ui.internal.Messages;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.Style;
import org.eclipse.vex.ui.internal.editor.DocumentFileCreationPage;
import org.eclipse.vex.ui.internal.editor.DocumentTypeSelectionPage;

public class NewDocumentWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private DocumentTypeSelectionPage typePage;
    private DocumentFileCreationPage filePage;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.setWindowTitle(Messages.getString("NewDocumentWizard.title"));
    }

    public void addPages() {
        this.typePage = new DocumentTypeSelectionPage();
        this.filePage = new DocumentFileCreationPage("filePage", this.selection);
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.filePage);
    }

    public boolean performFinish() {
        Style style;
        IDocument doc;
        block5: {
            try {
                doc = NewDocumentWizard.createDocument(this.typePage.getDocumentType(), this.typePage.getRootElementName());
                style = VexPlugin.getDefault().getPreferences().getPreferredStyle(this.typePage.getDocumentType());
                if (style != null) break block5;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.noStyles.title"), (String)Messages.getString("NewDocumentWizard.noStyles.message"));
                return false;
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("NewDocumentWizard.errorLoading.message"), this.filePage.getFileName(), ex.getMessage());
                VexPlugin.getDefault().log(4, message, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.errorLoading.title"), (String)("Unable to create " + this.filePage.getFileName()));
                return false;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DocumentWriter writer = new DocumentWriter();
        writer.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(style.getStyleSheet()));
        writer.write(doc, (OutputStream)baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.filePage.setInitialContents(bais);
        IFile file = this.filePage.createNewFile();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.vex.ui.internal.editor.VexEditor");
        IWorkbenchWindow activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)activeWorkbenchWindow);
            IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        this.typePage.saveSettings();
        return true;
    }

    private static IDocument createDocument(DocumentType documentType, String rootElementName) {
        if (NewDocumentWizard.isDTD(documentType)) {
            return NewDocumentWizard.createDocumentWithDTD(documentType, rootElementName);
        }
        return NewDocumentWizard.createDocumentWithSchema(documentType, rootElementName);
    }

    private static boolean isDTD(DocumentType documentType) {
        String systemId = documentType.getSystemId();
        return systemId != null && systemId.toLowerCase().endsWith(".dtd");
    }

    private static IDocument createDocumentWithDTD(DocumentType documentType, String rootElementName) {
        Document result = new Document(new QualifiedName(null, rootElementName));
        result.setPublicID(documentType.getPublicId());
        result.setSystemID(documentType.getSystemId());
        return result;
    }

    private static IDocument createDocumentWithSchema(DocumentType documentType, String rootElementName) {
        String defaultNamespaceUri = documentType.getNamespaceName();
        Document document = new Document(new QualifiedName(defaultNamespaceUri, rootElementName));
        Element root = document.getRootElement();
        root.declareDefaultNamespace(defaultNamespaceUri);
        WTPVEXValidator validator = new WTPVEXValidator(new DocumentContentModel(null, null, null, (IElement)root));
        int namespaceIndex = 1;
        for (String namespaceUri : validator.getRequiredNamespaces()) {
            if (defaultNamespaceUri.equals(namespaceUri)) continue;
            root.declareNamespace("ns" + namespaceIndex++, namespaceUri);
        }
        return document;
    }
}

