/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.gestures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.GraphWidget;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateGestureListener
implements GestureListener {
    GraphWidget graph;
    double rotate;
    List<GraphItem> nodes;
    List<Point> originalLocations;
    double xCenter;
    double yCenter;

    void storePosition(List<GraphItem> nodes) {
        this.originalLocations = new ArrayList<Point>();
        Iterator<GraphItem> it = nodes.iterator();
        Transform t = new Transform();
        t.setTranslation(-this.xCenter, -this.yCenter);
        while (it.hasNext()) {
            GraphNode node = (GraphNode)it.next();
            this.originalLocations.add(t.getTransformed(node.getLocation()));
        }
    }

    void updatePositions(double rotation) {
        Transform t = new Transform();
        t.setRotation(rotation);
        t.setTranslation(this.xCenter, this.yCenter);
        int i = 0;
        while (i < this.nodes.size()) {
            GraphNode node = (GraphNode)this.nodes.get(i);
            Point p = this.originalLocations.get(i);
            Point rot = t.getTransformed(p);
            node.setLocation(rot.preciseX(), rot.preciseY());
            ++i;
        }
    }

    public void gesture(GestureEvent e) {
        if (!(e.widget instanceof GraphWidget)) {
            return;
        }
        switch (e.detail) {
            case 2: {
                this.graph = (GraphWidget)e.widget;
                this.rotate = 0.0;
                this.nodes = this.graph.getSelection();
                if (this.nodes.isEmpty()) {
                    this.nodes.addAll(this.graph.getNodes());
                }
                this.xCenter = 0.0;
                this.yCenter = 0.0;
                for (GraphNode graphNode : this.nodes) {
                    Point location = graphNode.getLocation();
                    this.xCenter += location.preciseX();
                    this.yCenter += location.preciseY();
                }
                this.xCenter /= (double)this.nodes.size();
                this.yCenter /= (double)this.nodes.size();
                this.storePosition(this.nodes);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.updatePositions(e.rotation / 2.0 / Math.PI);
            }
        }
    }
}

