/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.cpsgenerator;

import java.util.Random;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.viatra.examples.cps.application.ui.cpsgenerator.ScalableConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.ICPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.AllocationCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.DemoCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.HostClassesCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.LargeCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.OnlyHostTypesCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.impl.SimpleCPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.scenario.impl.BasicScenario;
import org.eclipse.xtext.xbase.lib.Functions;

public class ConstraintTypePage
extends WizardPage {
    private Button detailedRadioButton;
    private Button simpleRadioButton;
    private Label simpleTypeLabel;
    private ComboViewer simpleType;
    private Button scalableRadioButton;
    private Label scalableTypeLabel;
    private ComboViewer scalableType;
    private Label scaleLabel;
    private Text scaleText;
    private Button openModelCheckButton;
    private Label seedLabel;
    private Text seedText;

    public ConstraintTypePage() {
        super("wizardPage");
        this.setDescription("Choose the type of model to generate");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        RadioButtonSelectionListener radioButtonListener = new RadioButtonSelectionListener();
        this.simpleRadioButton = new Button(container, 16);
        this.simpleRadioButton.setSelection(true);
        this.simpleRadioButton.setText("Simple Test Models");
        new Label(container, 0);
        this.simpleTypeLabel = new Label(container, 0);
        this.simpleTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.simpleTypeLabel.setText("Type:");
        this.simpleType = new ComboViewer(container, 8);
        this.simpleType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.simpleType.setInput((Object)new ICPSConstraints[]{new AllocationCPSConstraints(), new DemoCPSConstraints(), new HostClassesCPSConstraints(), new LargeCPSConstraints(), new OnlyHostTypesCPSConstraints(), new SimpleCPSConstraints()});
        this.simpleType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.getClass().getSimpleName();
            }
        });
        Combo simpleTypeCombo = this.simpleType.getCombo();
        simpleTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.simpleType.getCombo().select(0);
        this.scalableRadioButton = new Button(container, 16);
        this.scalableRadioButton.addSelectionListener((SelectionListener)radioButtonListener);
        this.scalableRadioButton.setText("Scalable Models");
        new Label(container, 0);
        this.scalableTypeLabel = new Label(container, 0);
        this.scalableTypeLabel.setText("Type:");
        this.scalableTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.scalableType = new ComboViewer(container, 8);
        this.scalableType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.scalableType.setInput((Object)new ScalableConstraints[]{new ScalableConstraints("BasicScenario (scale between 100 and 10 k)", (Functions.Function2<? super Integer, ? super Random, ? extends ICPSConstraints>)((Functions.Function2)(scale, rand) -> new BasicScenario(rand).getConstraintsFor(scale.intValue())))});
        Combo scalableTypeCombo = this.scalableType.getCombo();
        scalableTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.scalableType.getCombo().select(0);
        this.scaleLabel = new Label(container, 0);
        this.scaleLabel.setText("Scale:");
        this.scaleLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.scaleText = new Text(container, 2048);
        this.scaleText.addModifyListener(e -> this.getWizard().getContainer().updateButtons());
        this.scaleText.setText("1000");
        this.scaleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.detailedRadioButton = new Button(container, 16);
        this.detailedRadioButton.addSelectionListener((SelectionListener)radioButtonListener);
        this.detailedRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.detailedRadioButton.setText("Model by Detailed Constraints");
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.seedLabel = new Label(container, 0);
        this.seedLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.seedLabel.setText("Random seed:");
        this.seedText = new Text(container, 2048);
        this.seedText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.seedText.addModifyListener(e -> this.getWizard().getContainer().updateButtons());
        this.seedText.setText(Long.toString(System.nanoTime()));
        this.openModelCheckButton = new Button(container, 32);
        this.openModelCheckButton.setSelection(true);
        this.openModelCheckButton.setLayoutData((Object)new GridData(16384, 1024, false, false, 2, 1));
        this.openModelCheckButton.setText("Open model after generation ");
        this.initDataBindings();
    }

    public ICPSConstraints getConstraints() {
        if (this.simpleRadioButton.getSelection()) {
            return (ICPSConstraints)this.simpleType.getStructuredSelection().getFirstElement();
        }
        if (this.scalableRadioButton.getSelection()) {
            ScalableConstraints constraints = (ScalableConstraints)this.scalableType.getStructuredSelection().getFirstElement();
            return constraints.getConstraints(Integer.parseInt(this.scaleText.getText()), new Random(this.getSeed()));
        }
        return null;
    }

    public long getSeed() {
        return Long.parseLong(this.seedText.getText());
    }

    public boolean shouldOpenModel() {
        return this.openModelCheckButton.getSelection();
    }

    public IWizardPage getNextPage() {
        if (this.detailedRadioButton.getSelection()) {
            return super.getNextPage();
        }
        return null;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validate();
    }

    private boolean isScaleValid() {
        try {
            return Integer.parseInt(this.scaleText.getText()) >= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isSeedValid() {
        try {
            Long.parseLong(this.seedText.getText());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean validate() {
        if (this.scalableRadioButton == null || this.seedText == null) {
            return false;
        }
        if (this.scalableRadioButton.getSelection() && !this.isScaleValid()) {
            this.setErrorMessage("Enter a positive integer as scaling factor");
            return false;
        }
        if (!this.isSeedValid()) {
            this.setErrorMessage("Enter an integer as seed");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeEnabledLblSimpleTypeObserveWidget = WidgetProperties.enabled().observe((Widget)this.simpleTypeLabel);
        ISWTObservableValue observeSelectionSimpleRadioButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.simpleRadioButton);
        bindingContext.bindValue((IObservableValue)observeEnabledLblSimpleTypeObserveWidget, (IObservableValue)observeSelectionSimpleRadioButtonObserveWidget, null, null);
        ISWTObservableValue observeEnabledSimpleTypeComboObserveWidget = WidgetProperties.enabled().observe((Widget)this.simpleType.getCombo());
        bindingContext.bindValue((IObservableValue)observeEnabledSimpleTypeComboObserveWidget, (IObservableValue)observeSelectionSimpleRadioButtonObserveWidget, null, null);
        ISWTObservableValue observeEnabledScalableTypeComboObserveWidget = WidgetProperties.enabled().observe((Widget)this.scalableType.getCombo());
        ISWTObservableValue observeSelectionScalableRadioButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.scalableRadioButton);
        bindingContext.bindValue((IObservableValue)observeEnabledScalableTypeComboObserveWidget, (IObservableValue)observeSelectionScalableRadioButtonObserveWidget, null, null);
        ISWTObservableValue observeEnabledScaleTextObserveWidget = WidgetProperties.enabled().observe((Widget)this.scaleText);
        bindingContext.bindValue((IObservableValue)observeEnabledScaleTextObserveWidget, (IObservableValue)observeSelectionScalableRadioButtonObserveWidget, null, null);
        ISWTObservableValue observeEnabledLblScalableTypeObserveWidget = WidgetProperties.enabled().observe((Widget)this.scalableTypeLabel);
        bindingContext.bindValue((IObservableValue)observeEnabledLblScalableTypeObserveWidget, (IObservableValue)observeSelectionScalableRadioButtonObserveWidget, null, null);
        ISWTObservableValue observeEnabledLblScaleObserveWidget = WidgetProperties.enabled().observe((Widget)this.scaleLabel);
        bindingContext.bindValue((IObservableValue)observeEnabledLblScaleObserveWidget, (IObservableValue)observeSelectionScalableRadioButtonObserveWidget, null, null);
        return bindingContext;
    }

    private class RadioButtonSelectionListener
    extends SelectionAdapter {
        private RadioButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ConstraintTypePage.this.getWizard().getContainer().updateButtons();
        }
    }
}

