/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.operations;

import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.generator.dtos.AppClass;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.generator.utils.RandomUtils;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;

public class ApplicationInstanceGenerationOperation
implements IOperation<CPSFragment> {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.generator.impl.ApplicationInstanceGenerationOperation");
    private final AppClass applicationClass;
    private final ApplicationType appType;
    @Extension
    private CPSModelBuilderUtil modelBuilder;
    @Extension
    private RandomUtils randUtil;

    public ApplicationInstanceGenerationOperation(AppClass applicationClass, ApplicationType appType) {
        RandomUtils _randomUtils;
        CPSModelBuilderUtil _cPSModelBuilderUtil;
        this.applicationClass = applicationClass;
        this.appType = appType;
        this.modelBuilder = _cPSModelBuilderUtil = new CPSModelBuilderUtil();
        this.randUtil = _randomUtils = new RandomUtils();
    }

    public boolean execute(CPSFragment fragment) {
        try {
            boolean _xblockexpression = false;
            int numberOfAppInstances = this.randUtil.randInt(this.applicationClass.getNumberOfAppInstances(), fragment.getRandom());
            String _identifier = this.appType.getIdentifier();
            String _plus = "--> AppInstances of " + _identifier;
            String _plus_1 = String.valueOf(_plus) + " = ";
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(numberOfAppInstances);
            this.logger.debug((Object)_plus_2);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numberOfAppInstances, true);
            for (Integer i : _doubleDotLessThan) {
                String _identifier_1 = this.appType.getIdentifier();
                String _plus_3 = String.valueOf(_identifier_1) + ".inst";
                String _plus_4 = String.valueOf(_plus_3) + i;
                this.modelBuilder.prepareApplicationInstanceWithId(this.appType, _plus_4);
            }
            _xblockexpression = true;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

