/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.HostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class HostMapping
extends AbstractRule<HostInstanceMatch> {
    public HostMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<HostInstanceMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1 _function = it -> {
            Job<HostInstanceMatch> _appearedJob = this.getAppearedJob();
            Job<HostInstanceMatch> _updateJob = this.getUpdateJob();
            Job<HostInstanceMatch> _disappearedJob = this.getDisappearedJob();
            it.setRuleSpecification(Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getHostInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
            it.setPriority(1);
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<HostInstanceMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            String nodeIp = match.getHostInstance().getNodeIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Mapping host with IP: ");
            _builder.append(nodeIp);
            this.logger.debug((Object)_builder);
            DeploymentHost _createDeploymentHost = this.depFactory.createDeploymentHost();
            Procedures.Procedure1 _function_1 = it -> it.setIp(nodeIp);
            DeploymentHost host = (DeploymentHost)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentHost, (Procedures.Procedure1)_function_1);
            EList _hosts = this.getRootMapping().getDeployment().getHosts();
            _hosts.add((Object)host);
            EList _traces = this.getRootMapping().getTraces();
            CPS2DeploymentTrace _createCPS2DeploymentTrace = this.traceFactory.createCPS2DeploymentTrace();
            Procedures.Procedure1 _function_2 = it -> {
                EList _cpsElements = it.getCpsElements();
                HostInstance _hostInstance = match.getHostInstance();
                _cpsElements.add((Object)_hostInstance);
                EList _deploymentElements = it.getDeploymentElements();
                _deploymentElements.add((Object)host);
            };
            CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_2);
            _traces.add((Object)_doubleArrow);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Mapped host with IP: ");
            _builder_1.append(nodeIp);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<HostInstanceMatch> getUpdateJob() {
        IMatchProcessor _function = match -> {
            boolean _notEquals;
            DeploymentElement _depElement = this.cpsXformM2M.getCps2depTrace(this.engine).getOneArbitraryMatch(this.getRootMapping(), null, (Identifiable)match.getHostInstance(), null).getDepElement();
            DeploymentHost depHost = (DeploymentHost)_depElement;
            String hostIp = depHost.getIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Updating mapped host with IP: ");
            _builder.append(hostIp);
            this.logger.debug((Object)_builder);
            String nodeIp = match.getHostInstance().getNodeIp();
            boolean bl = _notEquals = !Objects.equal((Object)nodeIp, (Object)hostIp);
            if (_notEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("IP changed to ");
                _builder_1.append(nodeIp);
                this.logger.trace((Object)_builder_1);
                depHost.setIp(nodeIp);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Updated mapped host with IP: ");
            _builder_2.append(nodeIp);
            this.logger.debug((Object)_builder_2);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<HostInstanceMatch> getDisappearedJob() {
        IMatchProcessor _function = match -> {
            Cps2depTraceMatch traceMatch = this.cpsXformM2M.getCps2depTrace(this.engine).getOneArbitraryMatch(this.getRootMapping(), null, (Identifiable)match.getHostInstance(), null);
            String hostIp = match.getHostInstance().getNodeIp();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Removing host with IP: ");
            _builder.append(hostIp);
            this.logger.debug((Object)_builder);
            EList _hosts = this.getRootMapping().getDeployment().getHosts();
            DeploymentElement _depElement = traceMatch.getDepElement();
            _hosts.remove((Object)((DeploymentHost)_depElement));
            EList _traces = this.getRootMapping().getTraces();
            CPS2DeploymentTrace _trace = traceMatch.getTrace();
            _traces.remove((Object)_trace);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Removed host with IP: ");
            _builder_1.append(hostIp);
            this.logger.debug((Object)_builder_1);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

