/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class IterateOverContainers
extends ExtendOperation {
    private int sourcePosition;
    private boolean transitive;

    public IterateOverContainers(int containerPosition, int sourcePosition, boolean transitive) {
        super(containerPosition);
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Preconditions.checkState((boolean)(frame.get(this.sourcePosition) instanceof EObject), (String)"Only children of EObject elements are supported.");
        EObject source = (EObject)frame.get(this.sourcePosition);
        EObject container = source.eContainer();
        this.it = container == null ? Collections.emptyIterator() : (this.transitive ? new ParentIterator(source) : Collections.singleton(container).iterator());
    }

    public String toString() {
        return "extend    containment -" + this.sourcePosition + " <>--> +" + this.position + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position, this.sourcePosition);
    }

    private static final class ParentIterator
    implements Iterator<EObject> {
        private EObject current;

        public ParentIterator(EObject source) {
            this.current = source;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EObject next() {
            EObject newObject = this.current.eContainer();
            if (newObject == null) {
                throw new NoSuchElementException(String.format("No more parents available for EObject %s", this.current));
            }
            this.current = newObject;
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current.eContainer() != null;
        }
    }
}

