/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelMerger;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.INotificationManager;
import org.eclipse.viatra2.core.ITransactionManager;
import org.eclipse.viatra2.core.IUndoManager;
import org.eclipse.viatra2.core.simple.IDProvider;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelManager;
import org.eclipse.viatra2.core.simple.SimpleNotificationManager;
import org.eclipse.viatra2.core.simple.SimpleRelation;
import org.eclipse.viatra2.core.simple.SimpleTransactionManager;
import org.eclipse.viatra2.core.simple.UniqueNameProvider;
import org.eclipse.viatra2.core.simple.tempdata.TemporaryDataFactory;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.eclipse.viatra2.logger.Logger;

public class SimpleModelSpace
implements IModelSpace {
    protected TemporaryDataFactory<Set<IModelElement>> tempFactory = new TemporaryDataFactory();
    protected Logger logger;
    protected IModelManager mManager;
    protected INotificationManager nManager;
    protected ITransactionManager tManager;
    protected Map<Long, SimpleModelElement> entities;
    protected Map<Long, SimpleModelElement> relations;
    protected Set<SimpleEntity> entitiesSet;
    protected Set<SimpleRelation> relationsSet;
    protected SimpleEntity rootEntity;
    public static final boolean isAncestorAware = false;
    public static final String ancestorContainerName = "vpm";
    public static final String ancestorEntityName = "entity";
    public static final String ancestorEntityFQN = "vpm.entity";
    public static final String ancestorRelationName = "relation";
    public static final String ancestorRelationFQN = "vpm.entity.relation";
    protected SimpleEntity ancestorContainer;
    protected SimpleEntity ancestorEntity;
    protected SimpleRelation ancestorRelation;
    protected UniqueNameProvider uniqueNameProvider;
    protected IDProvider idProvider;
    protected int numberOfChanges = 0;
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected ReadWriteLock _lock = new ReadWriteLock(){
        NullRLock rLock;
        NullWLock wLock;
        {
            this.rLock = new NullRLock();
            this.wLock = new NullWLock();
        }

        @Override
        public Lock readLock() {
            return this.rLock;
        }

        @Override
        public Lock writeLock() {
            return this.wLock;
        }
    };
    IFramework framework;

    protected long newId() {
        return this.idProvider.newID();
    }

    String uniqueName(String s) {
        return this.uniqueNameProvider.uniqueName(s);
    }

    String uniqueName() {
        return this.uniqueNameProvider.uniqueName();
    }

    @Override
    public void init(IFramework fw) throws VPMRuntimeException {
        this.framework = fw;
        this.init(fw.getLogger(), fw.getProperties());
    }

    public void init(Logger log, VPMProperties props) throws VPMRuntimeException {
        this.logger = log;
        this.uniqueNameProvider = new UniqueNameProvider();
        this.idProvider = new IDProvider(this.logger);
        this.entities = new TreeMap<Long, SimpleModelElement>();
        this.entitiesSet = new TreeSet<SimpleEntity>();
        this.relations = new TreeMap<Long, SimpleModelElement>();
        this.relationsSet = new TreeSet<SimpleRelation>();
        this.rootEntity = new SimpleEntity(this.newId(), this);
        this.rootEntity.name = "root";
        this.initManagers();
    }

    protected void initManagers() throws VPMRuntimeException {
        this.mManager = new SimpleModelManager();
        this.nManager = new SimpleNotificationManager();
        this.tManager = new SimpleTransactionManager();
        ((SimpleModelManager)this.mManager).init(this.logger, this);
        ((SimpleNotificationManager)this.nManager).init(this.logger, this);
        ((SimpleTransactionManager)this.tManager).init(this.logger, this);
        this.nManager.addAllListener((ICoreNotificationListener)((Object)this.tManager));
    }

    @Override
    public IModelMerger getModelMerger() {
        return null;
    }

    @Override
    public IModelManager getModelManager() {
        return this.mManager;
    }

    @Override
    public INotificationManager getNotificationManager() {
        return this.nManager;
    }

    @Override
    public ITransactionManager getTransactionManager() {
        return this.tManager;
    }

    public IUndoManager getUndoManager() {
        this.logger.debug("SimpleModelSpace::getUndoManager called");
        return null;
    }

    @Override
    public boolean isTransactionAware() {
        return false;
    }

    @Override
    public boolean isNotificationAware() {
        return false;
    }

    @Override
    public boolean isUndoAware() {
        return true;
    }

    @Override
    public IModelSpace cloneModelSpace() {
        return null;
    }

    public String statistics() {
        return this.statistics(0L);
    }

    public String statistics(long memUsedBefore) {
        StringBuffer ret = new StringBuffer();
        int numSups = 0;
        int numSubs = 0;
        int numTypes = 0;
        int numInsts = 0;
        for (SimpleModelElement me : this.entities.values()) {
            numSubs += me.subtypes.size();
            numSups += me.supertype.size();
            numTypes += me.type.size();
            numInsts += me.instances.size();
        }
        for (SimpleModelElement me : this.relations.values()) {
            numSubs += me.subtypes.size();
            numSups += me.supertype.size();
            numTypes += me.type.size();
            numInsts += me.instances.size();
        }
        ret.append("Number uf supertypes:" + numSups + "\n");
        ret.append("Number uf subtypes:" + numSubs + "\n");
        ret.append("Number uf instance:" + numInsts + "\n");
        ret.append("Number uf types:" + numTypes + "\n");
        int nEnts = this.getModelManager().getEntities().size();
        int nRels = this.getModelManager().getRelations().size();
        ret.append("nr of entities:" + nEnts + "\n");
        ret.append("nr of rels    :" + nRels + "\n");
        int sum = nRels + nEnts;
        ret.append("nr of sum     :" + sum + "\n");
        ret.append("average num of types:" + (float)numTypes / (float)sum + "\n");
        ret.append("average num of supertypes:" + (float)numSups / (float)sum + "\n");
        System.gc();
        ret.append("memory per element:" + (SimpleModelSpace.memUsed() - memUsedBefore) / (long)sum);
        return ret.toString();
    }

    private static long memUsed() {
        Runtime r = Runtime.getRuntime();
        long free = r.freeMemory();
        long total = r.totalMemory();
        return total - free;
    }

    public void deleteStrings() {
        for (SimpleModelElement me : this.entities.values()) {
            SimpleEntity mee = (SimpleEntity)me;
            me.name = null;
            mee.value = null;
        }
        for (SimpleModelElement me : this.relations.values()) {
            me.name = null;
        }
    }

    public int discardAllTemp() {
        return this.tempFactory.discardAll();
    }

    @Override
    public Collection<IModelElement> getAncestorElements() {
        return Collections.emptySet();
    }

    @Override
    public IFramework getFramework() {
        return this.framework;
    }

    public class NullRLock
    implements Lock {
        @Override
        public void lock() {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2];
            String trace = String.valueOf(e.getClassName()) + "::" + e.getMethodName();
            System.out.println("READ_LOCK [" + trace + "]");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public Condition newCondition() {
            return null;
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2];
            String trace = String.valueOf(e.getClassName()) + "::" + e.getMethodName();
            System.out.println("READ UNLOCK [" + trace + "]");
        }
    }

    public class NullWLock
    implements Lock {
        @Override
        public void lock() {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2];
            String trace = String.valueOf(e.getClassName()) + "::" + e.getMethodName();
            System.out.println("WRITE_LOCK [" + trace + "]");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public Condition newCondition() {
            return null;
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
            StackTraceElement e = Thread.currentThread().getStackTrace()[2];
            String trace = String.valueOf(e.getClassName()) + "::" + e.getMethodName();
            System.out.println("WRITE UNLOCK [" + trace + "]");
        }
    }
}

