/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased.tracetree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.tracebased.TraceException;
import org.eclipse.viatra2.core.tracebased.TraceModelSpace;
import org.eclipse.viatra2.core.tracebased.TraceNotificationManager;
import org.eclipse.viatra2.core.tracebased.TraceTreeManager;
import org.eclipse.viatra2.core.tracebased.tracetree.AbstractTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;
import org.eclipse.viatra2.framework.IFramework;

public class CompositeTraceTreeNode
extends AbstractTraceTreeNode {
    private List<ICoreNotificationObject> events = new ArrayList<ICoreNotificationObject>();

    public CompositeTraceTreeNode(ITraceTreeNode parent, String id, ICoreNotificationObject startEvent) {
        super(parent, id);
        this.events.add(startEvent);
    }

    @Override
    public void doExecute(IFramework framework) throws TraceException {
        TraceTreeManager ttm;
        IModelSpace ms = framework.getTopmodel();
        if (ms instanceof TraceModelSpace) {
            ttm = ((TraceModelSpace)ms).getTraceManager();
            if (this.events.size() > 0) {
                ((TraceNotificationManager)ms.getNotificationManager()).setEnabled(false);
                ms.getTransactionManager().beginTransaction(Boolean.TRUE);
                try {
                    for (ICoreNotificationObject event : this.events) {
                        ttm.getTraceProcessor().doExecuteEvent(event);
                    }
                    ((TraceNotificationManager)ms.getNotificationManager()).setEnabled(true);
                }
                catch (TraceException e) {
                    ((TraceNotificationManager)ms.getNotificationManager()).setEnabled(true);
                    throw e;
                }
                ms.getTransactionManager().commitTransaction();
            }
        } else {
            throw (TraceException)new TraceException("doExecute not possible, model-space is not trace-based!").fillInStackTrace();
        }
        ttm.setCurrent(this);
    }

    @Override
    public void undo(IFramework framework) throws TraceException {
        TraceTreeManager ttm;
        IModelSpace ms = framework.getTopmodel();
        if (ms instanceof TraceModelSpace) {
            ttm = ((TraceModelSpace)ms).getTraceManager();
            if (this.events.size() > 0) {
                int i = this.events.size() - 1;
                while (i >= 0) {
                    ttm.getTraceProcessor().undoEvent(this.events.get(i));
                    --i;
                }
            }
        } else {
            throw (TraceException)new TraceException("Undo not possible, model-space is not trace-based!").fillInStackTrace();
        }
        ttm.setCurrent(this.getParent());
    }

    public List<ICoreNotificationObject> getEvents() {
        return this.events;
    }

    @Override
    public String toString() {
        String superString = super.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(superString);
        if (this.events.isEmpty()) {
            sb.append("; No events");
        } else {
            int i = 0;
            sb.append("; Events (").append(this.events.size()).append(")");
            for (ICoreNotificationObject event : this.events) {
                sb.append(" ").append(i).append(": ");
                sb.append(event.toString());
                ++i;
            }
        }
        return sb.toString();
    }
}

