/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.exports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.properties.VPMProperties;

public class VPMExporter {
    private static final String stripNonValidXMLCharacters(String in) {
        if (in == null || "".equals(in)) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        int l = in.length();
        int i = 0;
        while (i < l) {
            char c = in.charAt(i);
            if (VPMExporter.isValidXMLUnicodeCharacter(c)) {
                res.append(c);
            }
            ++i;
        }
        return res.toString();
    }

    private static final boolean isValidXMLUnicodeCharacter(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }

    public String escapeCharacters2(String _in) {
        String in = VPMExporter.stripNonValidXMLCharacters(_in);
        StringBuffer ret = new StringBuffer();
        char[] cArray = in.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch < ' ' || ch > '\u007f' || ch == '<' || ch == '>' || ch == '&' || ch == '[' || ch == '\"') {
                ret.append(this.char2escape(ch));
            } else {
                ret.append(ch);
            }
            ++n2;
        }
        return ret.toString();
    }

    private String char2escape(char ch) {
        return "&#" + ch + ";";
    }

    public void export(IFramework fw, String fileName) throws IOException {
        File f = new File(fileName);
        FileOutputStream stream = new FileOutputStream(f);
        this.export(fw, stream);
    }

    public void export(IFramework fw, OutputStream outputStream) throws IOException {
        IModelSpace ms = fw.getTopmodel();
        PrintWriter out = new PrintWriter(outputStream);
        out.println("<?xml version=\"1.0\" ?>");
        out.println("<VPM>");
        boolean writeProperties = true;
        if (writeProperties) {
            out.println("<PROPERTIES>");
            VPMProperties props = fw.getProperties();
            TreeMap<Object, Object> ts = new TreeMap<Object, Object>(props.getJavaProperties());
            for (Map.Entry<Object, Object> entry : ts.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                name = this.escapeCharacters2(name);
                value = this.escapeCharacters2(value);
                out.println("<PROPERTY name=\"" + name + "\" value=\"" + value + "\"/>");
            }
            out.println("</PROPERTIES>");
        }
        out.println("<MODEL>");
        out.println("<ROOTENTITY id=\"" + ms.getModelManager().getRoot().getID() + "\"/>");
        int i = 0;
        while (i < 2) {
            Iterator<IModelElement> it = null;
            String type = "";
            String tagClose = "";
            if (i == 0) {
                type = "ENTITY";
                out.println("<ENTITIES>");
                it = ms.getModelManager().getEntities().iterator();
                tagClose = "</ENTITIES>";
            }
            if (i == 1) {
                type = "RELATION";
                out.println("<RELATIONS>");
                it = ms.getModelManager().getRelations().iterator();
                tagClose = "</RELATIONS>";
            }
            while (it.hasNext()) {
                IEntity ent;
                IModelElement e = (IModelElement)it.next();
                if (e.equals(ms.getModelManager().getRoot())) continue;
                String isAny = "";
                if (i == 1) {
                    IRelation rel = (IRelation)e;
                    isAny = " isAnyFrom=\"" + Boolean.toString(rel.getIsAnyFrom()) + "\"" + " isAnyTo=\"" + Boolean.toString(rel.getIsAnyTo()) + "\"";
                }
                out.println("<" + type + " id=\"" + e.getID() + "\"" + isAny + ">");
                out.println("<NAME>" + this.escapeCharacters2(e.getName()) + "</NAME>");
                if (e.getViewInfo() != null) {
                    out.println("<VIEWINFO>" + this.escapeCharacters2(e.getViewInfo()) + "</VIEWINFO>");
                }
                out.println("<ISFINALTYPE>" + e.getIsFinalType() + "</ISFINALTYPE>");
                if (e.getTypes() != null) {
                    for (IModelElement me : e.getTypes()) {
                        out.println("<TYPE><MODELELEMENT idref=\"" + me.getID() + "\"/></TYPE>");
                    }
                }
                if (e.getSupertypes() != null) {
                    for (IModelElement me : e.getSupertypes()) {
                        out.println("<SUPERTYPE><MODELELEMENT idref=\"" + me.getID() + "\"/></SUPERTYPE>");
                    }
                }
                if (e instanceof IEntity && (ent = (IEntity)e).getParent() != null) {
                    IModelElement me;
                    me = ent.getParent();
                    out.println("<PARENT><ENTITY idref=\"" + me.getID() + "\"/></PARENT>");
                }
                if (e instanceof IEntity) {
                    ent = (IEntity)e;
                    out.println("<VALUE>" + this.escapeCharacters2(ent.getValue()) + "</VALUE>");
                }
                if (e instanceof IRelation) {
                    IRelation r = (IRelation)e;
                    if (r.getFrom() != null) {
                        out.println("<FROM><ENTITY idref=\"" + r.getFrom().getID() + "\"/></FROM>");
                    }
                    if (r.getTo() != null) {
                        out.println("<TO><ENTITY idref=\"" + r.getTo().getID() + "\"/></TO>");
                    }
                    out.print("<MULTIPLICITY>" + r.getMultiplicity().toString() + "</MULTIPLICITY>");
                    out.print("<ISAGGREGATION>" + r.getIsAggregation() + "</ISAGGREGATION>");
                    if (r.getInverse() != null) {
                        out.print("<INVERSE><RELATION idref=\"" + r.getInverse().getID() + "\"/></INVERSE>");
                    }
                }
                out.println("</" + type + ">");
            }
            out.println(tagClose);
            ++i;
        }
        out.println("</MODEL>");
        out.println("</VPM>");
        out.flush();
        out.close();
    }
}

