/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra2.framework.ExtensionProvider;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkException;
import org.eclipse.viatra2.framework.FrameworkManagerException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.osgi.framework.Bundle;

public class FrameworkManager {
    Map<String, Framework> frameworks = new TreeMap<String, Framework>();
    ArrayList<IFrameworkListChangedListener> listeners = new ArrayList();
    static FrameworkManager inst = null;
    private ExtensionProvider defExprovider;
    int counter = 0;

    public static FrameworkManager getInstance() {
        if (inst == null) {
            inst = new FrameworkManager();
        }
        return inst;
    }

    private FrameworkManager() {
    }

    public Framework getFramework(String id) {
        return this.frameworks.get(id);
    }

    public void setExtensionProvider(ExtensionProvider exProvider) {
        this.defExprovider = exProvider;
    }

    public IFramework createFramework(String fileName) throws FrameworkManagerException {
        return this.createFramework(fileName, this.getExtensionProvider());
    }

    public IFramework createFramework(InputStream file, String name) throws FrameworkManagerException {
        return this.createFramework(file, this.getExtensionProvider(), name);
    }

    private ExtensionProvider getExtensionProvider() {
        return this.defExprovider;
    }

    public IFramework createFramework(String fileName, ExtensionProvider exProvider) throws FrameworkManagerException {
        try {
            return this.createFramework(new FileInputStream(fileName), exProvider, fileName);
        }
        catch (FileNotFoundException e) {
            throw new FrameworkManagerException("file not found", e);
        }
    }

    public IFramework createFramework(InputStream fileStream, ExtensionProvider exProvider, String name) throws FrameworkManagerException {
        if (exProvider == null) {
            throw new FrameworkManagerException("Extension provider required.");
        }
        String id = this.genId();
        Framework newFramework = new Framework();
        try {
            newFramework.init(fileStream, id, exProvider, name);
        }
        catch (FrameworkException e) {
            throw new FrameworkManagerException("framework init", e);
        }
        this.frameworks.put(id, newFramework);
        for (IFrameworkListChangedListener l : new ArrayList<IFrameworkListChangedListener>(this.listeners)) {
            l.frameworkAdded(newFramework);
        }
        return newFramework;
    }

    public IFramework createFramework() throws FrameworkException {
        ExtensionProvider exProvider = this.getExtensionProvider();
        String id = this.genId();
        Framework newFramework = new Framework();
        newFramework.init(null, id, exProvider, "null");
        this.frameworks.put(id, newFramework);
        for (IFrameworkListChangedListener l : new ArrayList<IFrameworkListChangedListener>(this.listeners)) {
            l.frameworkAdded(newFramework);
        }
        return newFramework;
    }

    public void disposeFramework(String id) throws FrameworkManagerException {
        if (this.frameworks.containsKey(id)) {
            Framework fw = this.frameworks.get(id);
            fw.dispose();
            this.frameworks.remove(id);
            for (IFrameworkListChangedListener l : new ArrayList<IFrameworkListChangedListener>(this.listeners)) {
                l.frameworkRemoved(fw);
            }
        }
    }

    public String[] getAllFrameWorks() {
        return this.frameworks.keySet().toArray(new String[0]);
    }

    private String genId() {
        return "modelSpace" + this.counter++;
    }

    public void addFrameworkListChangedListener(IFrameworkListChangedListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeFrameworkListChangedListener(IFrameworkListChangedListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public static File convertURLtoFile(URL url) throws IllegalArgumentException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException uRISyntaxException2) {
                throw new IllegalArgumentException("The URL cannot be converted: " + url);
            }
        }
        return new File(uri);
    }

    public static File getFileFromBundle(String bundleId, String path) {
        if ("\\".equals(System.getProperty("file.separator"))) {
            path = path.replace('/', '\\');
        } else if ("/".equals(System.getProperty("file.separator"))) {
            path = path.replace('\\', '/');
        }
        File f = null;
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        URL fullPathString = null;
        try {
            fullPathString = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(path), null));
            f = FrameworkManager.convertURLtoFile(fullPathString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = new File(fullPathString.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }
}

