/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VPMImporterSaxImpl
extends DefaultHandler {
    private StringBuffer collectedString = new StringBuffer();
    private boolean collectString = false;
    private int stateField = 0;
    private int stateCollection = 0;
    private int stateElement = 0;
    private int stateModel = 0;
    private int stateParent = 0;
    private int stateModelElement = 0;
    private static final int STATE_MODELELEMENT_OFF = 0;
    private static final int STATE_MODELELEMENT_ON = 1;
    private static final int STATE_PARENT_OFF = 0;
    private static final int STATE_PARENT_ENTITY = 1;
    private static final int STATE_FIELD_OFF = 0;
    private static final int STATE_FIELD_VALUE = 1;
    private static final int STATE_FIELD_NAME = 2;
    private static final int STATE_FIELD_PARENT = 3;
    private static final int STATE_FIELD_TYPE = 4;
    private static final int STATE_FIELD_TO = 7;
    private static final int STATE_FIELD_SUPERTYPE = 5;
    private static final int STATE_FIELD_FROM = 6;
    private static final int STATE_FIELD_VIEW_INFO = 8;
    private static final int STATE_FIELD_MULTIPLICITY = 9;
    private static final int STATE_FIELD_ISAGGREGATION = 10;
    private static final int STATE_FIELD_INVERSE = 11;
    private static final int STATE_FIELD_ISFINALTYPE = 12;
    private static final int STATE_COLLECTION_OFF = 0;
    private static final int STATE_COLLECTION_RELATION = 1;
    private static final int STATE_COLLECTION_FUNCTION = 2;
    private static final int STATE_COLLECTION_ENTITY = 3;
    private static final int STATE_ELEMENT_OFF = 0;
    private static final int STATE_ELEMENT_ON = 1;
    private static final int STATE_MODEL_OUT = 0;
    private static final int STATE_MODEL_VPM = 1;
    private static final int STATE_MODEL_MODEL = 2;
    private static final String sVPM = "VPM";
    private static final String sPROPERTIES = "PROPERTIES";
    private static final String sPROPERTY = "PROPERTY";
    private static final String sPROPERTY_NAME = "name";
    private static final String sPROPERTY_VALUE = "value";
    private static final String sMODEL = "MODEL";
    private static final String sENTITIES = "ENTITIES";
    private static final String sENTITY = "ENTITY";
    private static final String sRELATIONS = "RELATIONS";
    private static final String sRELATION = "RELATION";
    private static final String sFUNCTIONS = "FUNCTIONS";
    private static final String sFUNCTION = "FUNCTION";
    private static final String sMODELELEMENT = "MODELELEMENT";
    private static final String sISFINALTYPE = "ISFINALTYPE";
    private static final String saID = "id";
    private static final String saAnyFrom = "isAnyFrom";
    private static final String saAnyTo = "isAnyTo";
    private static final String saIDREF = "idref";
    private static final String sPARENT = "PARENT";
    private static final String sNAME = "NAME";
    private static final String sVALUE = "VALUE";
    private static final String sTYPE = "TYPE";
    private static final String sFROM = "FROM";
    private static final String sTO = "TO";
    private static final String sVIEW_INFO = "VIEWINFO";
    private static final String sMULTIPLICITY = "MULTIPLICITY";
    private static final String sINVERSE = "INVERSE";
    private static final String sISAGGREGATION = "ISAGGREGATION";
    private static final String sSUPERTYPE = "SUPERTYPE";
    private static final String sROOTENTITY = "ROOTENTITY";
    private ModelElement modelElement = null;
    private String rootID = null;
    private Map<String, ModelElement> id2modelElement = new TreeMap<String, ModelElement>();
    private Map<String, ModelElement> id2entity = new TreeMap<String, ModelElement>();
    private boolean debug = false;
    IModelManager mManager;
    IModelSpace modelSpace;
    VPMProperties vprops;
    Properties props;
    private long timeInMillis;

    private void checkElement() {
        if (this.modelElement.getID() == null) {
            throw new RuntimeException("no id for element:" + this.modelElement.name);
        }
    }

    private void closeAndSaveElement() {
        if (this.modelElement.getType() == 0) {
            this.id2entity.put(this.modelElement.getID(), this.modelElement);
        }
        this.id2modelElement.put(this.modelElement.getID(), this.modelElement);
        if (this.debug) {
            String[] names = new String[]{"entity", "relation", "function"};
            this.debugMsg("-- new element: " + names[this.modelElement.getType()]);
            this.debugMsg("name: " + this.modelElement.getName());
            this.debugMsg("id: " + this.modelElement.getID());
            this.debugMsg("value: " + this.modelElement.getValue());
            this.debugMsg("parent: " + this.modelElement.getParent());
            this.debugMsg("from: " + this.modelElement.getFrom());
            this.debugMsg("to: " + this.modelElement.getTo());
            this.debugMsg("types: " + this.ListToString(this.modelElement.getTypes()));
            this.debugMsg("SUPERtypes: " + this.ListToString(this.modelElement.getSuperTypes()));
        }
        this.modelElement = null;
    }

    private String ListToString(List types) {
        return null;
    }

    private void debugMsg(String string) {
    }

    private void newEntity(String id) {
        this.modelElement = new ModelElement(id, 0);
    }

    private void newRelation(String id, boolean isAnyFrom, boolean isAnyTo) {
        this.modelElement = new ModelElement(id, 1);
        this.modelElement.setAnyFrom(isAnyFrom);
        this.modelElement.setAnyTo(isAnyTo);
    }

    private void newFunction(String id, boolean isAnyFrom, boolean isAnyTo) {
        this.modelElement = new ModelElement(id, 2);
        this.modelElement.setMultiplicity("0,-1,0,1");
        this.modelElement.setAnyFrom(isAnyFrom);
        this.modelElement.setAnyTo(isAnyTo);
    }

    private void _debugMsg(String str) {
        if (this.debug) {
            System.out.println(str);
        }
    }

    public String getName() {
        return "VPML Importer with SAX technology. Ver 0.1b. Schmidt Andras";
    }

    @Override
    public void startDocument() {
        this.debugMsg("Start document");
    }

    @Override
    public void endDocument() {
        this.debugMsg("End document");
    }

    private final void startElementInModel(String qName, Attributes atts) {
        block40: {
            block41: {
                block39: {
                    if (this.stateCollection != 0) break block39;
                    if (qName.equals(sENTITIES)) {
                        this.stateCollection = 3;
                    } else if (qName.equals(sRELATIONS)) {
                        this.stateCollection = 1;
                    } else if (qName.equals(sFUNCTIONS)) {
                        this.stateCollection = 2;
                    } else if (qName.equals(sROOTENTITY)) {
                        this.rootID = atts.getValue(saID);
                    }
                    break block40;
                }
                if (this.stateElement != 0) break block41;
                switch (this.stateCollection) {
                    case 3: {
                        if (qName.equals(sENTITY)) {
                            this.newEntity(atts.getValue(saID));
                            this.stateElement = 1;
                            break;
                        }
                        break block40;
                    }
                    case 2: {
                        if (qName.equals(sFUNCTION)) {
                            this.newFunction(atts.getValue(saID), Boolean.parseBoolean(atts.getValue(saAnyFrom)), Boolean.parseBoolean(atts.getValue(saAnyTo)));
                            this.stateElement = 1;
                            break;
                        }
                        break block40;
                    }
                    case 1: {
                        if (!qName.equals(sRELATION)) break block40;
                        this.newRelation(atts.getValue(saID), Boolean.parseBoolean(atts.getValue(saAnyFrom)), Boolean.parseBoolean(atts.getValue(saAnyTo)));
                        this.stateElement = 1;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block40;
            }
            switch (this.stateField) {
                case 0: {
                    if (qName.equals(sTYPE)) {
                        this.stateField = 4;
                        break;
                    }
                    if (qName.equals(sSUPERTYPE)) {
                        this.stateField = 5;
                        break;
                    }
                    if (qName.equals(sPARENT)) {
                        this.stateField = 3;
                        break;
                    }
                    if (qName.equals(sNAME)) {
                        this.startCollection();
                        this.stateField = 2;
                        break;
                    }
                    if (qName.equals(sVALUE)) {
                        this.startCollection();
                        this.stateField = 1;
                        break;
                    }
                    if (qName.equals(sVIEW_INFO)) {
                        this.startCollection();
                        this.stateField = 8;
                        break;
                    }
                    if (qName.equals(sMULTIPLICITY)) {
                        this.startCollection();
                        this.stateField = 9;
                        break;
                    }
                    if (qName.equals(sINVERSE)) {
                        this.stateField = 11;
                        break;
                    }
                    if (qName.equals(sISAGGREGATION)) {
                        this.startCollection();
                        this.stateField = 10;
                        break;
                    }
                    if (qName.equals(sISFINALTYPE)) {
                        this.startCollection();
                        this.stateField = 12;
                        break;
                    }
                    if (qName.equals(sFROM)) {
                        this.stateField = 6;
                        break;
                    }
                    if (!qName.equals(sTO)) break;
                    this.stateField = 7;
                    break;
                }
                case 3: {
                    if (!qName.equals(sENTITY)) break;
                    this.modelElement.setParent(atts.getValue(saIDREF));
                    this.stateParent = 1;
                    break;
                }
                case 6: {
                    if (!qName.equals(sENTITY)) break;
                    this.modelElement.setFrom(atts.getValue(saIDREF));
                    this.stateParent = 1;
                    break;
                }
                case 7: {
                    if (!qName.equals(sENTITY)) break;
                    this.modelElement.setTo(atts.getValue(saIDREF));
                    this.stateParent = 1;
                    break;
                }
                case 11: {
                    if (!qName.equals(sRELATION)) break;
                    this.modelElement.setInverse(atts.getValue(saIDREF));
                    this.stateParent = 1;
                    break;
                }
                case 4: {
                    if (qName.equals(sMODELELEMENT)) {
                        this.modelElement.addType(atts.getValue(saIDREF));
                        this.stateModelElement = 1;
                        break;
                    }
                    this.stateError();
                    break;
                }
                case 5: {
                    if (qName.equals(sMODELELEMENT)) {
                        this.modelElement.addSupertype(atts.getValue(saIDREF));
                        this.stateModelElement = 1;
                        break;
                    }
                    this.stateError();
                }
            }
        }
    }

    private void addProperty(Attributes atts) {
        String name = atts.getValue(sPROPERTY_NAME);
        String value = atts.getValue(sPROPERTY_VALUE);
        this.props.put(name, value);
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.stateModel == 2) {
            this.startElementInModel(qName, atts);
        } else {
            switch (this.stateModel) {
                case 0: {
                    if (!qName.equals(sVPM)) break;
                    this.stateModel = 1;
                    break;
                }
                case 1: {
                    if (qName.equals(sMODEL)) {
                        this.stateModel = 2;
                    }
                    if (!qName.equals(sPROPERTY)) break;
                    this.addProperty(atts);
                }
            }
        }
    }

    private void closeCollection() {
        this.collectString = false;
        this.collectedString.delete(0, this.collectedString.length());
    }

    private void startCollection() {
        this.collectString = true;
    }

    private String getCollectedStringAndClose() {
        String ret = this.collectedString.toString();
        this.closeCollection();
        return ret;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.stateField != 0) {
            if (this.stateParent != 0) {
                if (qName.equals(sENTITY) || qName.equals(sRELATION)) {
                    this.stateParent = 0;
                } else {
                    this.stateError();
                }
            } else if (this.stateModelElement != 0) {
                if (qName.equals(sMODELELEMENT)) {
                    this.stateModelElement = 0;
                } else {
                    this.stateError();
                }
            } else {
                switch (this.stateField) {
                    case 2: {
                        if (qName.equals(sNAME)) {
                            this.modelElement.setName(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 1: {
                        if (qName.equals(sVALUE)) {
                            this.modelElement.setValue(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 8: {
                        if (qName.equals(sVIEW_INFO)) {
                            this.modelElement.setViewInfo(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 9: {
                        if (qName.equals(sMULTIPLICITY)) {
                            this.modelElement.setMultiplicity(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 10: {
                        if (qName.equals(sISAGGREGATION)) {
                            this.modelElement.setIsAggregation(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 12: {
                        if (qName.equals(sISFINALTYPE)) {
                            this.modelElement.setIsFinalType(this.getCollectedStringAndClose());
                            break;
                        }
                        this.stateError();
                        break;
                    }
                    case 11: {
                        if (qName.equals(sINVERSE)) break;
                        this.stateError();
                        break;
                    }
                    case 4: {
                        if (qName.equals(sTYPE)) break;
                        this.stateError();
                        break;
                    }
                    case 5: {
                        if (qName.equals(sSUPERTYPE)) break;
                        this.stateError();
                        break;
                    }
                    case 3: {
                        if (qName.equals(sPARENT)) break;
                        this.stateError();
                        break;
                    }
                    case 6: {
                        if (qName.equals(sFROM)) break;
                        this.stateError();
                        break;
                    }
                    case 7: {
                        if (qName.equals(sTO)) break;
                        this.stateError();
                    }
                }
                this.stateField = 0;
            }
        } else if (this.stateElement == 1) {
            switch (this.stateCollection) {
                case 3: {
                    if (qName.equals(sENTITY)) {
                        this.checkElement();
                        this.closeAndSaveElement();
                    }
                    this.stateElement = 0;
                    break;
                }
                case 1: {
                    if (qName.equals(sRELATION)) {
                        this.checkElement();
                        this.closeAndSaveElement();
                    }
                    this.stateElement = 0;
                    break;
                }
                case 2: {
                    if (qName.equals(sFUNCTION)) {
                        this.checkElement();
                        this.closeAndSaveElement();
                    }
                    this.stateElement = 0;
                }
            }
        } else {
            if (qName.equals(sENTITIES) || qName.equals(sRELATIONS) || qName.equals(sFUNCTIONS)) {
                this.stateCollection = 0;
            }
            if (qName.equals(sMODEL)) {
                this.stateModel = 1;
            }
            if (qName.equals(sVPM)) {
                this.stateModel = 0;
            }
        }
    }

    private void stateError() {
        throw new RuntimeException("file format is corrupt");
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.collectString) {
            this.collectedString.append(ch, start, length);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    private void generateModelSpace() throws VPMImporterException {
        if (this.rootID == null) {
            throw new VPMImporterException("modelspace must contain root");
        }
        ModelElement rootMeta = new ModelElement(this.rootID, 0);
        rootMeta.setName("root");
        rootMeta.setModelElement(this.mManager.getRoot());
        this.id2entity.put(this.rootID, rootMeta);
        this.id2modelElement.put(this.rootID, rootMeta);
        this._debugMsg("building containment tree");
        Iterator<Map.Entry<String, ModelElement>> it = this.id2entity.entrySet().iterator();
        while (it.hasNext()) {
            ModelElement me = it.next().getValue();
            String pID = me.getParent();
            if (pID == null) {
                if (me.getID().equals(this.rootID)) continue;
                throw new VPMImporterException("element must have a parent:" + me.getName() + " with id:" + me.getID());
            }
            ModelElement parent = this.id2entity.get(pID);
            if (parent == null) {
                this._debugMsg(pID);
            }
            parent.addChild(me.getID());
        }
        try {
            IRelation newRel;
            ModelElement me;
            this._debugMsg("creating entities");
            this.createEntityWithChildren(this.rootID, null);
            this._debugMsg("creating relations");
            it = this.id2modelElement.entrySet().iterator();
            IEntity root = this.mManager.getRoot();
            while (it.hasNext()) {
                me = it.next().getValue();
                int type = me.getType();
                if (type == 0) continue;
                newRel = null;
                newRel = type == 1 ? this.mManager.newRelation(root, root) : this.mManager.newRelation(root, root);
                this.mManager.setViewInfo(newRel, me.getViewInfo());
                this.mManager.setIsFinalType(newRel, "true".equalsIgnoreCase(me.getIsFinalType()));
                me.setModelElement(newRel);
            }
            this._debugMsg("setting function, and relation from and to places");
            it = this.id2modelElement.entrySet().iterator();
            while (it.hasNext()) {
                ModelElement m;
                me = it.next().getValue();
                int type = me.getType();
                if (type == 0) continue;
                newRel = (IRelation)me.getModelElement();
                IModelElement from = this.id2modelElement.get(me.getFrom()).getModelElement();
                IModelElement to = this.id2modelElement.get(me.getTo()).getModelElement();
                this.mManager.setRelationFrom(newRel, from);
                this.mManager.setRelationTo(newRel, to);
                this.mManager.setIsAnyFrom(newRel, me.isAnyFrom);
                this.mManager.setIsAnyTo(newRel, me.isAnyTo);
                this.mManager.setName(newRel, me.getName());
                if (me.getMultiplicity() != null) {
                    if (me.getMultiplicity().equals(EMultiplicityKind.MANY_TO_MANY.toString())) {
                        this.mManager.setRelationMultiplicity(newRel, EMultiplicityKind.MANY_TO_MANY);
                    } else if (me.getMultiplicity().equals(EMultiplicityKind.ONE_TO_MANY.toString())) {
                        this.mManager.setRelationMultiplicity(newRel, EMultiplicityKind.ONE_TO_MANY);
                    } else if (me.getMultiplicity().equals(EMultiplicityKind.MANY_TO_ONE.toString())) {
                        this.mManager.setRelationMultiplicity(newRel, EMultiplicityKind.MANY_TO_ONE);
                    } else if (me.getMultiplicity().equals(EMultiplicityKind.ONE_TO_ONE.toString())) {
                        this.mManager.setRelationMultiplicity(newRel, EMultiplicityKind.ONE_TO_ONE);
                    }
                }
                if (me.getIsAggregation() != null && me.getIsAggregation().equalsIgnoreCase("true")) {
                    this.mManager.setRelationIsAggregation(newRel, true);
                }
                if (me.getInverse() != null && (m = this.id2modelElement.get(me.getInverse())) != null) {
                    IRelation inv = (IRelation)m.getModelElement();
                    this.mManager.setRelationInverse(newRel, inv);
                }
                if (newRel.getName().equals(me.getName())) continue;
                IModelElement par = newRel.getNamespace();
                IModelElement clasher = par.getElementInNamespaceByName(me.getName());
                this.mManager.setName(clasher, String.valueOf(clasher.getName()) + "!");
                this.mManager.setName(newRel, me.getName());
            }
            this._debugMsg("creating type relations between elements, setting names of relations");
            it = this.id2modelElement.entrySet().iterator();
            while (it.hasNext()) {
                ModelElement modE = it.next().getValue();
                IModelElement me2 = modE.getModelElement();
                List list = null;
                int j = 0;
                while (j < 2) {
                    list = j == 0 ? modE.getTypes() : modE.getSuperTypes();
                    int i = 0;
                    while (i < list.size()) {
                        String parID = (String)list.get(i);
                        IModelElement type = this.id2modelElement.get(parID).getModelElement();
                        String msg = null;
                        if (j == 0) {
                            try {
                                this.mManager.newInstanceOfEditor(type, me2);
                            }
                            catch (VPMCoreException e) {
                                this.mManager.newInstanceOfMachine(type, me2);
                                msg = e.getMessage();
                            }
                        } else {
                            try {
                                this.mManager.newSupertypeOfEditor(type, me2);
                            }
                            catch (VPMCoreException e) {
                                this.mManager.newSupertypeOfMachine(type, me2);
                                msg = e.getMessage();
                            }
                        }
                        if (msg != null) {
                            this._debugMsg(msg);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (VPMCoreException e) {
            e.printStackTrace();
        }
    }

    private void createEntityWithChildren(String id, IEntity parent) throws VPMCoreException {
        ModelElement me = this.id2entity.get(id);
        IEntity newEnt = null;
        newEnt = !id.equals(this.rootID) ? this.mManager.newEntity(me.getName(), me.getValue(), parent) : this.mManager.getRoot();
        this.mManager.setViewInfo(newEnt, me.getViewInfo());
        this.mManager.setIsFinalType(newEnt, "true".equalsIgnoreCase(me.getIsFinalType()));
        me.setModelElement(newEnt);
        if (me.containment != null) {
            for (String idChild : me.containment) {
                this.createEntityWithChildren(idChild, newEnt);
            }
        }
    }

    public IModelSpace process(InputStream f, IModelSpace ms, VPMProperties props) throws VPMRuntimeException {
        this.timeInMillis = System.currentTimeMillis();
        this._debugMsg("Loading modelspace starts at:" + this.timeInMillis);
        this.modelSpace = ms;
        this.vprops = props;
        this.props = new Properties();
        this.mManager = ms.getModelManager();
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            sp.parse(f, (DefaultHandler)this);
            this.generateModelSpace();
            this.vprops.loadFromJavaProperties(this.props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VPMRuntimeException("Error loading model", e);
        }
        long endTime = System.currentTimeMillis();
        this._debugMsg("Loading modelspace ended at:" + endTime + " finished in: " + (endTime - this.timeInMillis) + " millis");
        return this.modelSpace;
    }

    private class ModelElement
    implements Comparable {
        public static final int ENTITY = 0;
        public static final int RELATION = 1;
        public static final int FUNCTION = 2;
        private String id = null;
        private String multiplicity = null;
        private String isAggregation = null;
        private String Inverse = null;
        private String isfinaltype = null;
        private String name = "";
        private String parent = null;
        private String value = "";
        private String viewInfo = null;
        private String from = null;
        private String to = null;
        private int type;
        private boolean isAnyFrom = false;
        private boolean isAnyTo = false;
        private List<String> types = new ArrayList<String>();
        private List<String> superTypes = new ArrayList<String>();
        private Set<String> containment = null;
        private IModelElement me = null;

        void setModelElement(IModelElement me) {
            this.me = me;
        }

        IModelElement getModelElement() {
            return this.me;
        }

        String getID() {
            return this.id;
        }

        int getType() {
            return this.type;
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }

        String getViewInfo() {
            return this.viewInfo;
        }

        void setViewInfo(String viewInfo) {
            this.viewInfo = viewInfo;
        }

        void setMultiplicity(String multiplicity) {
            this.multiplicity = multiplicity;
        }

        String getMultiplicity() {
            return this.multiplicity;
        }

        void setIsAggregation(String isa) {
            this.isAggregation = isa;
        }

        String getIsAggregation() {
            return this.isAggregation;
        }

        void setInverse(String inv) {
            this.Inverse = inv;
        }

        String getInverse() {
            return this.Inverse;
        }

        void setIsFinalType(String isft) {
            this.isfinaltype = isft;
        }

        String getIsFinalType() {
            return this.isfinaltype;
        }

        String getFrom() {
            return this.from;
        }

        void setFrom(String from) {
            this.from = from;
        }

        String getTo() {
            return this.to;
        }

        void setTo(String to) {
            this.to = to;
        }

        List getTypes() {
            return this.types;
        }

        void addType(String type) {
            this.types.add(type);
        }

        List getSuperTypes() {
            return this.superTypes;
        }

        void addSupertype(String supertype) {
            this.superTypes.add(supertype);
        }

        String getParent() {
            return this.parent;
        }

        void setParent(String parent) {
            this.parent = parent;
        }

        void addChild(String id) {
            if (this.containment == null) {
                this.containment = new TreeSet<String>();
            }
            this.containment.add(id);
        }

        public ModelElement(String id, int type) {
            this.id = id;
            this.type = type;
        }

        public int compareTo(Object arg0) {
            return this.id.compareTo(((ModelElement)arg0).id);
        }

        public boolean isAnyFrom() {
            return this.isAnyFrom;
        }

        public void setAnyFrom(boolean isAnyFrom) {
            this.isAnyFrom = isAnyFrom;
        }

        public boolean isAnyTo() {
            return this.isAnyTo;
        }

        public void setAnyTo(boolean isAnyTo) {
            this.isAnyTo = isAnyTo;
        }
    }

    class VPMImporterException
    extends VPMRuntimeException {
        private static final long serialVersionUID = 1L;

        public VPMImporterException(String msg) {
            super(msg);
        }
    }
}

