/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.merger;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.merger.VPMMergeException;

public class Merger {
    IModelManager leftManager;
    IModelManager rightManager;
    Collection<IRelation> newlyCreatedRelations = new TreeSet<IRelation>();
    Map<String, String> mapFqn = new TreeMap<String, String>();
    private static final int ENT = 0;
    private static final int REL = 1;

    public void merge(IModelSpace leftModel, IModelSpace rightModel) throws VPMMergeException {
        try {
            try {
                this.leftManager = leftModel.getModelManager();
                this.rightManager = rightModel.getModelManager();
                IEntity leftRoot = this.leftManager.getRoot();
                IEntity rightRoot = this.rightManager.getRoot();
                this.mergeElementsInBaranch(leftRoot, rightRoot);
                this.setNewRelationsTarget();
                this.mergeTypes();
            }
            catch (VPMCoreException e) {
                e.printStackTrace();
                VPMMergeException toThrow = new VPMMergeException("Core threw while merging (internal error):" + e.getMessage());
                toThrow.initCause(e);
                throw toThrow;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                VPMMergeException toThrow = new VPMMergeException("Runtime exception while merging (internal error)");
                toThrow.initCause(e);
                throw toThrow;
            }
        }
        finally {
            this.leftManager = null;
            this.rightManager = null;
        }
    }

    private void mergeTypes() throws VPMCoreException {
        int i = 0;
        while (i < 2) {
            Iterator<IModelElement> it = i == 0 ? this.leftManager.getEntities().iterator() : this.leftManager.getRelations().iterator();
            while (it.hasNext()) {
                IModelElement left = it.next();
                IModelElement right = this.leftModelElement2RightModelElement(left);
                if (right == null) continue;
                this.mergeTypes(left, right);
            }
            ++i;
        }
    }

    private void mergeTypes(IModelElement left, IModelElement right) throws VPMCoreException {
        IModelElement rightType;
        for (IModelElement leftType : left.getTypes()) {
            rightType = this.leftModelElement2RightModelElement(leftType);
            if (right.isInstanceOf(rightType)) continue;
            this.rightManager.newInstanceOfMachine(rightType, right);
        }
        for (IModelElement leftType : left.getSupertypes()) {
            rightType = this.leftModelElement2RightModelElement(leftType);
            if (right.isInstanceOf(rightType)) continue;
            this.rightManager.newSupertypeOfMachine(rightType, right);
        }
    }

    private void setNewRelationsTarget() throws VPMCoreException {
        for (IRelation rel : this.newlyCreatedRelations) {
            IRelation rightRel = (IRelation)this.leftModelElement2RightModelElement(rel);
            IModelElement tg = rel.getTo();
            IModelElement rightTg = this.leftModelElement2RightModelElement(tg);
            this.rightManager.setRelationTo(rightRel, rightTg);
        }
    }

    private IModelElement leftModelElement2RightModelElement(IModelElement lMe) {
        String fqn = lMe.getFullyQualifiedName();
        String mapName = this.mapFqn.get(fqn);
        if (mapName == null) {
            mapName = fqn;
        }
        IModelElement ret = this.rightManager.getElementByName(mapName);
        return ret;
    }

    private void mergeElementsInBaranch(IModelElement leftEntity, IModelElement rightEntity) throws VPMCoreException {
        for (IModelElement leftMe : leftEntity.getElementsInNamespace()) {
            IModelElement rightMe = rightEntity.getElementInNamespaceByName(leftMe.getName());
            if (rightMe != null && this.getType(rightMe) == this.getType(leftMe)) {
                this.mergeElementsInBaranch(leftMe, rightMe);
                continue;
            }
            this.createElementsInBranch(leftMe, rightEntity);
        }
    }

    private void createElementsInBranch(IModelElement leftContent, IModelElement rightEntity) throws VPMCoreException {
        IModelElement right = null;
        if (this.getType(leftContent) == 0) {
            right = this.rightManager.newEntity(leftContent.getName(), ((IEntity)leftContent).getValue(), (IEntity)rightEntity);
        } else {
            right = this.rightManager.newRelation(leftContent.getName(), rightEntity, rightEntity);
            this.rightManager.setRelationMultiplicity((IRelation)right, ((IRelation)leftContent).getMultiplicity());
            this.rightManager.setRelationIsAggregation((IRelation)right, ((IRelation)leftContent).getIsAggregation());
            this.newlyCreatedRelations.add((IRelation)leftContent);
        }
        this.rightManager.setViewInfo(right, leftContent.getViewInfo());
        this.rightManager.setIsFinalType(right, leftContent.getIsFinalType());
        if (!right.getFullyQualifiedName().equals(leftContent.getFullyQualifiedName())) {
            this.mapFqn.put(leftContent.getFullyQualifiedName(), right.getFullyQualifiedName());
        }
        for (IModelElement left : leftContent.getElementsInNamespace()) {
            this.createElementsInBranch(left, right);
        }
    }

    private int getType(IModelElement me) {
        if (me instanceof IEntity) {
            return 0;
        }
        if (me instanceof IRelation) {
            return 1;
        }
        return -1;
    }
}

