/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text.light;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.editor.text.Activator;

public class VTEColorProvider {
    private static final RGB RGB_DEFAULT = new RGB(58, 58, 58);
    private static final RGB RGB_KEYWORD = new RGB(42, 34, 127);
    public static final RGB RGB_STRING = new RGB(255, 0, 42);
    public static final RGB RGB_COMMENT = new RGB(63, 127, 95);
    protected Map<Object, Color> fColorTable = new HashMap<Object, Color>(10);

    public static void initializeDefaults(IPreferenceStore aStore) {
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"VTMLEditor.color.default", (RGB)RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"VTMLEditor.color.keyword", (RGB)RGB_KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"VTMLEditor.color.string", (RGB)RGB_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)aStore, (String)"VTMLEditor.color.comment", (RGB)RGB_COMMENT);
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(String aName) {
        Color color = this.fColorTable.get(aName);
        if (color == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)("VTMLEditor.color." + aName));
            color = rgb != null ? new Color((Device)Display.getCurrent(), rgb) : Display.getCurrent().getSystemColor(24);
            this.fColorTable.put(aName, color);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }
}

