/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.commands;

import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;

public class DeleteModelElementCommand
extends ViatraEditorCommand {
    private IEntity parent;
    private String parent_name;
    private String child_name;
    private IEntity child;
    private IModelElement source;
    private String source_name;
    private String relation_name;
    private IRelation relation;

    public void setEntity(IEntity aChld) {
        this.child = aChld;
        this.child_name = this.child.getFullyQualifiedName();
        this.parent = this.child.getParent();
        this.parent_name = this.parent.getFullyQualifiedName();
        this.relation_name = null;
        this.relation = null;
        this.source = null;
        this.source_name = null;
    }

    public void setRelation(IRelation aRel) {
        this.relation = aRel;
        this.relation_name = this.relation.getFullyQualifiedName();
        this.source = this.relation.getFrom();
        this.source_name = this.source.getFullyQualifiedName();
        this.parent = null;
        this.parent_name = null;
        this.child = null;
        this.child_name = null;
    }

    private void recursive_delete(IEntity target) {
        while (!target.getContents().isEmpty()) {
            try {
                this.recursive_delete((IEntity)target.getContents().iterator().next());
            }
            catch (ClassCastException classCastException) {
                System.out.println("Non-entity content detected at " + target.getFullyQualifiedName());
            }
        }
        try {
            target.getModelSpace().getModelManager().deleteEntity(target, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
        }
        catch (VPMCoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void execute() throws VPMCoreException {
        this.parent = (IEntity)this.Lookup((IModelElement)this.parent, this.parent_name);
        this.child = (IEntity)this.Lookup((IModelElement)this.child, this.child_name);
        this.source = this.Lookup(this.source, this.source_name);
        this.relation = (IRelation)this.Lookup((IModelElement)this.relation, this.relation_name);
        if (this.parent != null && this.child != null) {
            this.iTransactionID = this.child.getModelSpace().getTransactionManager().beginUndoableTransaction((Object)Boolean.TRUE);
            try {
                this.recursive_delete(this.child);
                this.parent.getModelSpace().getTransactionManager().commitTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.parent.getModelSpace().getTransactionManager().abortTransaction();
            }
        } else if (this.source != null && this.relation != null) {
            this.iTransactionID = this.relation.getModelSpace().getTransactionManager().beginUndoableTransaction((Object)Boolean.TRUE);
            this.relation.getModelSpace().getModelManager().deleteElement((IModelElement)this.relation, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
            this.source.getModelSpace().getTransactionManager().commitTransaction();
        }
    }

    @Override
    public void undo() {
        this.parent = (IEntity)this.Lookup((IModelElement)this.parent, this.parent_name);
        this.source = this.Lookup(this.source, this.source_name);
        if (this.parent != null) {
            this.parent.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
        } else if (this.source != null) {
            this.source.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
        }
    }
}

