/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.FrameworkManagerException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.wizard.IWizardCategoryContributor;
import org.eclipse.viatra2.treeeditor.wizard.IWizardModelContributor;
import org.osgi.framework.Bundle;

public class ViatraTreeEditorNewVPMLWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection iSelection;
    protected ViatraEditorNewVPMLWizardPage iMainPage;
    protected ViatraEditorNewVPMLWizardSelectionPage iSelectionPage;

    public boolean performFinish() {
        IFile newFile;
        if (!this.iMainPage.isPageComplete()) {
            return false;
        }
        if (!this.iSelectionPage.isPageComplete()) {
            return false;
        }
        String basefn = this.iMainPage.getFileName();
        if (!basefn.endsWith(".vpml")) {
            this.iMainPage.setFileName(String.valueOf(basefn) + ".vpml");
        }
        if ((newFile = this.iMainPage.createNewFile()) == null) {
            return true;
        }
        String filename = newFile.getLocation().toOSString();
        FrameworkManager fwm = FrameworkManager.getInstance();
        IFramework iViatra = null;
        try {
            try {
                iViatra = fwm.createFramework();
                Vector<IWizardModelContributor> v = new Vector<IWizardModelContributor>();
                Object[] objectArray = this.iSelectionPage.treeviewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof IWizardModelContributor) {
                        v.add((IWizardModelContributor)o);
                    }
                    ++n2;
                }
                Collections.sort(v);
                for (IWizardModelContributor mc : v) {
                    String pluginid = mc.getPluginID();
                    File f = null;
                    if (mc.getFileVPML() != null) {
                        f = this.getFragmentFile_fixed_3(pluginid, mc.getFileVPML());
                        iViatra.mergeFile(f.getAbsolutePath());
                        continue;
                    }
                    if (mc.getFileVTML() == null) continue;
                    f = this.getFragmentFile_fixed_3(pluginid, mc.getFileVTML());
                    iViatra.nativeImport(f.getAbsolutePath(), (String)iViatra.getNativeImportersForExtension("vtml").iterator().next());
                }
                iViatra.saveFile(filename);
            }
            catch (Exception e) {
                e.printStackTrace();
                iViatra.getLogger().message(0, "Error merging modelspace: " + e.getClass().getCanonicalName(), (Throwable)e);
                try {
                    fwm.disposeFramework(iViatra.getId());
                    newFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (FrameworkManagerException e2) {
                    iViatra.getLogger().fatal(((Object)((Object)e2)).getClass().getCanonicalName());
                }
                catch (CoreException e3) {
                    iViatra.getLogger().fatal(((Object)((Object)e3)).getClass().getCanonicalName());
                }
                return false;
            }
        }
        finally {
            try {
                fwm.disposeFramework(iViatra.getId());
                newFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (FrameworkManagerException e) {
                iViatra.getLogger().fatal(((Object)((Object)e)).getClass().getCanonicalName());
            }
            catch (CoreException e) {
                iViatra.getLogger().fatal(((Object)((Object)e)).getClass().getCanonicalName());
            }
        }
        return true;
    }

    private File getFragmentFile_fixed_3(String bundleId, String path) {
        if ("\\".equals(System.getProperty("file.separator"))) {
            path = path.replace('/', '\\');
        } else if ("/".equals(System.getProperty("file.separator"))) {
            path = path.replace('\\', '/');
        }
        File f = null;
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null || !BundleUtility.isReady((Bundle)bundle)) {
            return null;
        }
        URL fullPathString = null;
        try {
            fullPathString = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(path), null));
            f = FrameworkManager.convertURLtoFile((URL)fullPathString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = new File(fullPathString.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.iSelection = selection;
        this.setWindowTitle("Create new VPML modelspace");
    }

    public void addPages() {
        this.iMainPage = new ViatraEditorNewVPMLWizardPage(this.iSelection);
        this.addPage((IWizardPage)this.iMainPage);
        this.iSelectionPage = new ViatraEditorNewVPMLWizardSelectionPage("Select modelspace fragments");
        this.addPage((IWizardPage)this.iSelectionPage);
    }

    public class ViatraEditorNewVPMLWizardPage
    extends WizardNewFileCreationPage {
        public ViatraEditorNewVPMLWizardPage(IStructuredSelection aSelection) {
            super("This wizard creates a new VPML modelspace", aSelection);
            this.setFileName("example.vpml");
        }
    }

    public class ViatraEditorNewVPMLWizardSelectionPage
    extends WizardPage {
        public CheckboxTreeViewer treeviewer;
        public TableViewer tableviewer;

        protected ViatraEditorNewVPMLWizardSelectionPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            SashForm sashform = new SashForm(parent, 2560);
            this.treeviewer = new CheckboxTreeViewer((Composite)sashform);
            this.treeviewer.setLabelProvider((IBaseLabelProvider)new InternalLabelProvider());
            this.treeviewer.setContentProvider((IContentProvider)new InternalContentProvider());
            this.treeviewer.setInput((Object)Plugin.getDefault());
            this.tableviewer = new TableViewer((Composite)sashform);
            TableLayout tlay = new TableLayout();
            tlay.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            tlay.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
            this.tableviewer.getTable().setLayout((Layout)tlay);
            TableColumn keyC = new TableColumn(this.tableviewer.getTable(), 16384);
            keyC.setText("Key");
            TableColumn valC = new TableColumn(this.tableviewer.getTable(), 16384);
            valC.setText("Value");
            this.tableviewer.getTable().setHeaderVisible(true);
            this.tableviewer.getTable().setLinesVisible(true);
            this.tableviewer.setLabelProvider((IBaseLabelProvider)new InternalTableLabelProvider());
            this.tableviewer.setContentProvider((IContentProvider)new InternalTableContentProvider());
            this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    try {
                        ViatraEditorNewVPMLWizardSelectionPage.this.tableviewer.setInput((Object)event.getSelection());
                    }
                    catch (Exception exception) {}
                }
            });
            this.treeviewer.setComparer(new IElementComparer(){

                public boolean equals(Object a, Object b) {
                    boolean aIsCategory = a instanceof IWizardCategoryContributor;
                    boolean bIsCategory = b instanceof IWizardCategoryContributor;
                    boolean aIsModel = a instanceof IWizardModelContributor;
                    boolean bIsModel = b instanceof IWizardModelContributor;
                    if (aIsCategory && bIsCategory) {
                        return ((IWizardCategoryContributor)a).getID().equalsIgnoreCase(((IWizardCategoryContributor)b).getID());
                    }
                    if (aIsModel && bIsModel) {
                        return ((IWizardModelContributor)a).getID().equalsIgnoreCase(((IWizardModelContributor)b).getID());
                    }
                    return false;
                }

                public int hashCode(Object element) {
                    return element.hashCode();
                }
            });
            this.treeviewer.addCheckStateListener(new ICheckStateListener(){

                protected void check(Object element, boolean state) {
                    if (ViatraEditorNewVPMLWizardSelectionPage.this.treeviewer.getChecked(element) == state) {
                        return;
                    }
                    ViatraEditorNewVPMLWizardSelectionPage.this.treeviewer.setChecked(element, state);
                    ICheckable _dummy = new ICheckable(){

                        public void addCheckStateListener(ICheckStateListener listener) {
                        }

                        public boolean getChecked(Object element) {
                            return false;
                        }

                        public void removeCheckStateListener(ICheckStateListener listener) {
                        }

                        public boolean setChecked(Object element, boolean state) {
                            return false;
                        }
                    };
                    this.checkStateChanged(new CheckStateChangedEvent(_dummy, element, state));
                }

                private void _colorize(Object element, TreeItem item, Color c) {
                    if (ViatraEditorNewVPMLWizardSelectionPage.this.treeviewer.getComparer().equals(item.getData(), element)) {
                        item.setForeground(c);
                    } else {
                        TreeItem[] treeItemArray = item.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem child = treeItemArray[n2];
                            this._colorize(element, child, c);
                            ++n2;
                        }
                    }
                }

                protected void colorize(Object element, int color) {
                    Color c = null;
                    switch (color) {
                        default: {
                            c = new Color((Device)Display.getDefault(), 0, 0, 0);
                            break;
                        }
                        case 1: {
                            c = new Color((Device)Display.getDefault(), 255, 0, 0);
                            break;
                        }
                        case 2: {
                            c = new Color((Device)Display.getDefault(), 127, 127, 127);
                        }
                    }
                    TreeItem[] treeItemArray = ViatraEditorNewVPMLWizardSelectionPage.this.treeviewer.getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem topitem = treeItemArray[n2];
                        this._colorize(element, topitem, c);
                        ++n2;
                    }
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    block20: {
                        block19: {
                            if (!(event.getElement() instanceof IWizardCategoryContributor)) break block19;
                            IWizardCategoryContributor cc = (IWizardCategoryContributor)event.getElement();
                            if (event.getChecked()) {
                                for (IWizardModelContributor mc : Plugin.getDefault().getModelContributions()) {
                                    if (!mc.getCategoryID().equalsIgnoreCase(cc.getID())) continue;
                                    this.colorize(mc, 0);
                                    this.check(mc, true);
                                }
                            } else {
                                for (IWizardModelContributor mc : Plugin.getDefault().getModelContributions()) {
                                    if (!mc.getCategoryID().equalsIgnoreCase(cc.getID())) continue;
                                    this.check(mc, false);
                                }
                            }
                            break block20;
                        }
                        if (!(event.getElement() instanceof IWizardModelContributor)) break block20;
                        IWizardModelContributor mc = (IWizardModelContributor)event.getElement();
                        if (event.getChecked()) {
                            this.colorize(mc, 0);
                            for (IWizardCategoryContributor cc : Plugin.getDefault().getCategoryContributions()) {
                                if (!cc.getID().equalsIgnoreCase(mc.getCategoryID())) continue;
                                int i = 0;
                                for (IWizardModelContributor iWizardModelContributor : Plugin.getDefault().getModelContributions()) {
                                    if (iWizardModelContributor.getCategoryID().equalsIgnoreCase(mc.getCategoryID())) {
                                        ++i;
                                    }
                                    if (i > 1) break;
                                }
                                if (i != true) continue;
                                this.check(cc, true);
                                break;
                            }
                            for (String rid : mc.getRequiredIDs()) {
                                for (IWizardModelContributor rmc : Plugin.getDefault().getModelContributions()) {
                                    if (!rmc.getID().equalsIgnoreCase(rid)) continue;
                                    this.colorize(rmc, 0);
                                    this.check(rmc, true);
                                }
                            }
                            for (String fid : mc.getForbiddenIDs()) {
                                for (IWizardModelContributor rmc : Plugin.getDefault().getModelContributions()) {
                                    if (!rmc.getID().equalsIgnoreCase(fid)) continue;
                                    this.colorize(rmc, 1);
                                    this.check(rmc, false);
                                }
                            }
                        } else {
                            for (IWizardCategoryContributor cc : Plugin.getDefault().getCategoryContributions()) {
                                if (!cc.getID().equalsIgnoreCase(mc.getCategoryID())) continue;
                                int i = 0;
                                for (IWizardModelContributor iWizardModelContributor : Plugin.getDefault().getModelContributions()) {
                                    if (iWizardModelContributor.getCategoryID().equalsIgnoreCase(mc.getCategoryID())) {
                                        ++i;
                                    }
                                    if (i > 1) break;
                                }
                                if (i != true) continue;
                                this.check(cc, false);
                                break;
                            }
                            for (String fid : mc.getForbiddenIDs()) {
                                for (IWizardModelContributor rmc : Plugin.getDefault().getModelContributions()) {
                                    if (!rmc.getID().equalsIgnoreCase(fid)) continue;
                                    this.colorize(rmc, 0);
                                }
                            }
                            for (IWizardModelContributor _mc : Plugin.getDefault().getModelContributions()) {
                                if (!_mc.getRequiredIDs().contains(mc.getID())) continue;
                                this.colorize(_mc, 2);
                                this.check(_mc, false);
                            }
                        }
                    }
                }
            });
            this.setDescription("Select the appropriate modelspace fragments for your new modelspace");
            sashform.setWeights(new int[]{2, 1});
            this.setControl((Control)sashform);
        }

        protected class InternalContentProvider
        implements ITreeContentProvider {
            protected InternalContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IWizardCategoryContributor) {
                    String catid = ((IWizardCategoryContributor)parentElement).getID();
                    Vector<IWizardModelContributor> v = new Vector<IWizardModelContributor>();
                    for (IWizardModelContributor mc : Plugin.getDefault().getModelContributions()) {
                        if (!mc.getCategoryID().equalsIgnoreCase(catid)) continue;
                        v.add(mc);
                    }
                    return v.toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof IWizardModelContributor) {
                    for (IWizardCategoryContributor cc : Plugin.getDefault().getCategoryContributions()) {
                        if (!cc.getID().equalsIgnoreCase(((IWizardModelContributor)element).getCategoryID())) continue;
                        return cc;
                    }
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IWizardCategoryContributor) {
                    String catid = ((IWizardCategoryContributor)element).getID();
                    for (IWizardModelContributor mc : Plugin.getDefault().getModelContributions()) {
                        if (!mc.getCategoryID().equalsIgnoreCase(catid)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Plugin) {
                    return Plugin.getDefault().getCategoryContributions().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        protected class InternalLabelProvider
        extends LabelProvider {
            protected InternalLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof IWizardCategoryContributor) {
                    return ((IWizardCategoryContributor)element).getName();
                }
                if (element instanceof IWizardModelContributor) {
                    return ((IWizardModelContributor)element).getName();
                }
                return null;
            }
        }

        protected class InternalTableContentProvider
        implements IStructuredContentProvider {
            protected InternalTableContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                IStructuredSelection sel;
                if (inputElement instanceof IStructuredSelection && (sel = (IStructuredSelection)inputElement).getFirstElement() instanceof IWizardModelContributor) {
                    IWizardModelContributor mc = (IWizardModelContributor)sel.getFirstElement();
                    Vector<TableDummy> v = new Vector<TableDummy>();
                    v.add(new TableDummy(0, "ID", mc.getID()));
                    v.add(new TableDummy(1, "Name", mc.getName()));
                    v.add(new TableDummy(2, "Description", mc.getDescription()));
                    v.add(new TableDummy(3, "Contained fragment ids", mc.getContainedIDs()));
                    v.add(new TableDummy(4, "Required fragment ids", mc.getRequiredIDs()));
                    v.add(new TableDummy(5, "Forbidden fragment ids", mc.getForbiddenIDs()));
                    v.add(new TableDummy(6, "VTML File", mc.getFileVTML()));
                    v.add(new TableDummy(7, "VPML File", mc.getFileVPML()));
                    return v.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        protected class InternalTableLabelProvider
        implements ITableLabelProvider {
            protected InternalTableLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((TableDummy)element).key;
                }
                if (columnIndex == 1) {
                    TableDummy td = (TableDummy)element;
                    switch (td.id) {
                        default: {
                            return td.value == null ? "" : td.value.toString();
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                    }
                    Collection ss = (Collection)td.value;
                    String r = "";
                    for (String s : ss) {
                        r = String.valueOf(r) + s + "; ";
                    }
                    return r;
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }

        protected class TableDummy {
            public String key;
            public Object value;
            public int id;

            public TableDummy(int i, String k, Object v) {
                this.id = i;
                this.key = k;
                this.value = v;
            }
        }
    }
}

