/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment.BlockRuleExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.BlockRuleInterpreterHelper;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternMatcherParameters;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IGTRuleMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.PatternMatcherProvider;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.BlockRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ChooseRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.CollectionIteratorRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ForallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.LetRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.VariableDefinition;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.interpreters.IProgressReport;

public class BlockRuleInterpreter
extends RuleInterpreter {
    private static BlockRuleInterpreter _instance = new BlockRuleInterpreter();

    private BlockRuleInterpreter() {
    }

    public static BlockRuleInterpreter getInstance() {
        return _instance;
    }

    @Override
    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, ASMRuleInvocation ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        BlockRule blockRule = (BlockRule)ruleToBeInterpreted;
        if (blockRule instanceof LetRule) {
            LetRule letBlockRule = (LetRule)ruleToBeInterpreted;
            return this.interpretLetRule(executionEnvironment, letBlockRule, pr);
        }
        if (blockRule instanceof ForallRule) {
            ForallRule forallBlockRule = (ForallRule)blockRule;
            if (forallBlockRule.getGtrule() == null) {
                if (forallBlockRule.getCondition() instanceof GTPatternCall) {
                    return this.interpretForallRulewithGTPattern(executionEnvironment, forallBlockRule, pr);
                }
                return this.interpretForallRulewithASMFunction(executionEnvironment, forallBlockRule, pr);
            }
            return this.interpretForallRulewithGTRule(executionEnvironment, forallBlockRule, pr);
        }
        if (blockRule instanceof ChooseRule) {
            ChooseRule chooseBlockRule = (ChooseRule)blockRule;
            if (chooseBlockRule.getGtrule() == null) {
                if (chooseBlockRule.getCondition() instanceof GTPatternCall) {
                    return this.interpretChooseRulewithGTPattern(executionEnvironment, chooseBlockRule, pr);
                }
                return this.interpretChooseRulewithASMFunction(executionEnvironment, chooseBlockRule, pr);
            }
            return this.interpretChooseRulewithGTRule(executionEnvironment, chooseBlockRule, pr);
        }
        return Boolean.FALSE;
    }

    private Boolean interpretLetRule(IExecutionEnvironment executionEnvironment, LetRule letBlockRule, IProgressReport pr) throws ViatraTransformationException {
        BlockRuleExecutionEnvironment letRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), letBlockRule.getBody());
        Hashtable childExecutionEnvironmentVariables = new Hashtable();
        childExecutionEnvironmentVariables.putAll(executionEnvironment.getVariableValues());
        for (Object variableDefinition : letBlockRule.getDefinitions()) {
            VariableDefinition varDef = (VariableDefinition)variableDefinition;
            childExecutionEnvironmentVariables.put(varDef.getVariable(), varDef.getValue() == null ? ValueKind.UNDEF_LITERAL : TermEvaluator.getInstance().evaluate(executionEnvironment, varDef.getValue()));
        }
        letRuleExecutionEnvironment.onBegin(childExecutionEnvironmentVariables);
        Boolean result = RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)letRuleExecutionEnvironment, letBlockRule.getBody(), pr);
        childExecutionEnvironmentVariables = (Hashtable)letRuleExecutionEnvironment.onTerminate();
        for (Variable variable : executionEnvironment.getVariableValues().keySet()) {
            try {
                executionEnvironment.setVariableValue(variable, childExecutionEnvironmentVariables.get(variable));
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{variable.getName(), e.getMessage()};
                throw new ASMInterpreterException("Error at setting the value of the {1} variable after returning from the {2} native ASM rule call: {3}", context, (AnnotatedElement)letBlockRule);
            }
        }
        return result;
    }

    private Boolean interpretForallRulewithGTRule(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Collection<IMatching> lHSmatches;
        IGTRuleMatcher gtMatcher;
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        GTRule gtRule = forallBlockRule.getGtrule().getRule();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = BlockRuleInterpreterHelper.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)forallBlockRule);
        BlockRuleExecutionEnvironment gtEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework());
        parameterParameterScopes = BlockRuleInterpreterHelper.getScopesFromContainmentConstraints(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule);
        PatternMatcherParameters mp = BlockRuleInterpreterHelper.getGTRuleMatchParameters(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule, parameterParameterScopes, gtRule, forallBlockRule.getGtrule());
        try {
            gtMatcher = PatternMatcherProvider.getInstance().getGtRuleMatcher((IExecutionEnvironment)gtEnvironment, gtRule, mp);
            lHSmatches = gtMatcher.initMatchAll(mp.getCallSignature(), mp.getInputMapping(), mp.getQuantificationOrder());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)forallBlockRule);
        }
        if (lHSmatches != null && lHSmatches.size() != 0) {
            lHSmatches = BlockRuleInterpreterHelper.reorder(gtRule.getPrecondition().getCalledPattern(), lHSmatches);
            for (IMatching lHSMatch : lHSmatches) {
                Object[] match;
                try {
                    match = gtMatcher.matchAll(lHSMatch, mp.getCallSignature(), mp.getInputMapping());
                }
                catch (ViatraTransformationException e1) {
                    throw e1.addNewStackElement((EObject)forallBlockRule);
                }
                BlockRuleInterpreterHelper.evaulateDoPartofGTRuleInvocation(gtRule, match, (BlockRule)forallBlockRule, forallRuleExecutionEnvironment, forallBlockRule.getGtrule(), pr);
            }
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretForallRulewithASMFunction(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        HashMap valueList = new HashMap();
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : forallBlockRule.getLocalVariables()) {
            valueList.put((Variable)variable, new Vector());
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        executionEnvironment.fetchVariableVariations(valueList, forallBlockRule.getCondition());
        Object[] keys = valueList.keySet().toArray();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), forallBlockRule.getBody());
        forallRuleExecutionEnvironment.onBegin(variables);
        Vector<Integer> divVect = new Vector<Integer>();
        divVect.add(new Integer(((Vector)valueList.get(keys[0])).size()));
        Integer maxCount = new Integer(((Vector)valueList.get(keys[0])).size());
        int iter = 1;
        while (iter < valueList.size()) {
            maxCount = maxCount * ((Vector)valueList.get(keys[iter])).size();
            divVect.add(((Vector)valueList.get(keys[iter])).size());
            if (((Vector)valueList.get(keys[iter])).size() == 0) {
                return Boolean.TRUE;
            }
            ++iter;
        }
        Integer size = divVect.size();
        Integer iter_config = 0;
        while (iter_config < maxCount) {
            Integer config_no = new Integer(iter_config);
            int iter_var = 0;
            while (iter_var < size) {
                Variable variable = (Variable)valueList.keySet().toArray()[iter_var];
                try {
                    forallRuleExecutionEnvironment.setVariableValue(variable, ((Vector)valueList.get(valueList.keySet().toArray()[iter_var])).get(config_no % (Integer)divVect.get(iter_var)));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable: {2} ", context, (AnnotatedElement)forallBlockRule);
                }
                config_no = (config_no - config_no % (Integer)divVect.get(iter_var)) / (Integer)divVect.get(iter_var);
                ++iter_var;
            }
            if (Boolean.TRUE.equals(TermEvaluator.getInstance().evaluate((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getCondition()))) {
                RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getBody(), pr);
            }
            iter_config = iter_config + 1;
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretForallRulewithGTPattern(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Collection<IMatching> matches;
        PatternMatcherParameters mp;
        int i = 0;
        GTPatternCall forallGTPatternCall = (GTPatternCall)forallBlockRule.getCondition();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = BlockRuleInterpreterHelper.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)forallBlockRule);
        HashMap<Variable, Scope> parameterParameterScopes = BlockRuleInterpreterHelper.getScopesFromContainmentConstraints(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule);
        try {
            IPatternMatcher patternMatcher = PatternMatcherProvider.getInstance().getPatternMatcher((IExecutionEnvironment)forallRuleExecutionEnvironment, forallGTPatternCall.getCalledPattern());
            mp = BlockRuleInterpreterHelper.getMatchParameters(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule, parameterParameterScopes);
            matches = patternMatcher.matchAll(mp.getInputMapping(), mp.getCallSignature(), mp.getQuantificationOrder());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)forallBlockRule);
        }
        matches = BlockRuleInterpreterHelper.reorder(forallGTPatternCall.getCalledPattern(), matches);
        for (IMatching match : matches) {
            i = 0;
            while (i < forallGTPatternCall.getActualParameters().size()) {
                if (mp.getCallSignature()[i].getParameterMode().equals((Object)ParameterMode.OUTPUT)) {
                    Variable variable = ((VariableReference)forallGTPatternCall.getActualParameters().get(i)).getVariable();
                    try {
                        forallRuleExecutionEnvironment.setVariableValue(variable, match.lookup(i));
                    }
                    catch (ViatraTransformationException e) {
                        String[] context = new String[]{variable.getName(), e.getMessage()};
                        throw new ASMInterpreterException("Error at setting the initial value of the {1} variable in the forall execution context: {2} ", context, (AnnotatedElement)forallBlockRule);
                    }
                }
                ++i;
            }
            RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getBody(), pr);
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretChooseRulewithGTPattern(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        IMatching match;
        PatternMatcherParameters mp;
        int i = 0;
        GTPatternCall chooseGTPatternCall = (GTPatternCall)chooseBlockRule.getCondition();
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = BlockRuleInterpreterHelper.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        parameterParameterScopes = BlockRuleInterpreterHelper.getScopesFromContainmentConstraints(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        GTPattern gtPattern = chooseGTPatternCall.getCalledPattern();
        boolean isRandom = false;
        for (Object annot : gtPattern.getRuntimeAnnotations()) {
            if (!"@random".equals(((RuntimeAnnotation)annot).getAnnotationName().toLowerCase())) continue;
            isRandom = true;
            break;
        }
        try {
            IPatternMatcher patternMatcher = PatternMatcherProvider.getInstance().getPatternMatcher((IExecutionEnvironment)chooseRuleExecutionEnvironment, gtPattern);
            mp = BlockRuleInterpreterHelper.getMatchParameters(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule, parameterParameterScopes);
            match = !isRandom ? patternMatcher.match(mp.getInputMapping(), mp.getCallSignature()) : patternMatcher.matchRandomly(mp.getInputMapping(), mp.getCallSignature());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)chooseBlockRule);
        }
        if (match == null) {
            return Boolean.FALSE;
        }
        i = 0;
        while (i < chooseGTPatternCall.getActualParameters().size()) {
            if (mp.getCallSignature()[i].getParameterMode().equals((Object)ParameterMode.OUTPUT)) {
                Variable variable = ((VariableReference)chooseGTPatternCall.getActualParameters().get(i)).getVariable();
                try {
                    chooseRuleExecutionEnvironment.setVariableValue(variable, match.lookup(i));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable in the choose execution context: {2} ", context, (AnnotatedElement)chooseBlockRule);
                }
            }
            ++i;
        }
        Boolean result = RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getBody(), pr);
        chooseRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
        }
        return result;
    }

    private Boolean interpretChooseRulewithASMFunction(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        HashMap valueList = new HashMap();
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : chooseBlockRule.getLocalVariables()) {
            valueList.put((Variable)variable, new Vector());
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        executionEnvironment.fetchVariableVariations(valueList, chooseBlockRule.getCondition());
        Object[] keys = valueList.keySet().toArray();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), chooseBlockRule.getBody());
        chooseRuleExecutionEnvironment.onBegin(variables);
        Vector<Integer> divVect = new Vector<Integer>();
        divVect.add(new Integer(((Vector)valueList.get(keys[0])).size()));
        Integer maxCount = new Integer(((Vector)valueList.get(keys[0])).size());
        int iter = 1;
        while (iter < valueList.size()) {
            maxCount = maxCount * ((Vector)valueList.get(keys[iter])).size();
            divVect.add(((Vector)valueList.get(keys[iter])).size());
            if (((Vector)valueList.get(keys[iter])).size() == 0) {
                return Boolean.FALSE;
            }
            ++iter;
        }
        Integer size = divVect.size();
        Integer iter_config = 0;
        while (iter_config < maxCount) {
            Integer config_no = new Integer(iter_config);
            int iter_var = 0;
            while (iter_var < size) {
                Variable variable = (Variable)valueList.keySet().toArray()[iter_var];
                try {
                    chooseRuleExecutionEnvironment.setVariableValue(variable, ((Vector)valueList.get(valueList.keySet().toArray()[iter_var])).get(config_no % (Integer)divVect.get(iter_var)));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable: {2} ", context, (AnnotatedElement)chooseBlockRule);
                }
                config_no = (config_no - config_no % (Integer)divVect.get(iter_var)) / (Integer)divVect.get(iter_var);
                ++iter_var;
            }
            if (Boolean.TRUE.equals(TermEvaluator.getInstance().evaluate((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getCondition()))) {
                boolean result = RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getBody(), pr);
                chooseRuleExecutionEnvironment.onTerminate();
                for (Variable var : executionEnvironment.getVariableValues().keySet()) {
                    executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
                }
                return result;
            }
            chooseRuleExecutionEnvironment.onTerminate();
            for (Variable var : executionEnvironment.getVariableValues().keySet()) {
                executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
            }
            iter_config = iter_config + 1;
        }
        return Boolean.FALSE;
    }

    private Boolean interpretChooseRulewithGTRule(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Object[] match;
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        GTRule gtRule = chooseBlockRule.getGtrule().getRule();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = BlockRuleInterpreterHelper.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        BlockRuleExecutionEnvironment gtEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework());
        parameterParameterScopes = BlockRuleInterpreterHelper.getScopesFromContainmentConstraints(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        PatternMatcherParameters mp = BlockRuleInterpreterHelper.getGTRuleMatchParameters(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule, parameterParameterScopes, gtRule, chooseBlockRule.getGtrule());
        try {
            IGTRuleMatcher gtMatcher = PatternMatcherProvider.getInstance().getGtRuleMatcher((IExecutionEnvironment)gtEnvironment, gtRule, mp);
            match = gtMatcher.match(mp.getCallSignature(), mp.getInputMapping());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)chooseBlockRule);
        }
        if (match != null) {
            Boolean result = BlockRuleInterpreterHelper.evaulateDoPartofGTRuleInvocation(gtRule, match, (BlockRule)chooseBlockRule, chooseRuleExecutionEnvironment, chooseBlockRule.getGtrule(), pr);
            chooseRuleExecutionEnvironment.onTerminate();
            for (Variable var : executionEnvironment.getVariableValues().keySet()) {
                executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
            }
            return result;
        }
        return Boolean.FALSE;
    }

    public static /* bridge */ /* synthetic */ RuleInterpreter getInstance() {
        return BlockRuleInterpreter.getInstance();
    }
}

