/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import java.util.Hashtable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.extension.INativeASMRule;
import org.eclipse.viatra2.gtasm.interpreter.extension.NativeASMRuleProvider;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.JavaNativeValue;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.DirectionKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.CallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;

public class NativeASMRuleInterpreter {
    private static NativeASMRuleInterpreter _instance = new NativeASMRuleInterpreter();

    public static NativeASMRuleInterpreter getInstance() {
        return _instance;
    }

    public boolean executeNativeASMRule(IExecutionEnvironment executionEnvironment, Hashtable<Variable, Object> symVarBindings, CallRule callRule) throws ViatraTransformationException {
        INativeASMRule nativeRule = NativeASMRuleProvider.getNativeASMRule((String)callRule.getRule().getFqn());
        if (nativeRule == null) {
            String[] context = new String[]{callRule.getRule().getFqn()};
            throw new ASMInterpreterException("No native ASM rule extension is available with the following id: {1}", context, (AnnotatedElement)callRule);
        }
        boolean result = false;
        Hashtable<Variable, Variable> outVarBindings = new Hashtable<Variable, Variable>();
        EList symParams = callRule.getRule().getSymParameters();
        try {
            result = nativeRule.invoke(executionEnvironment.getFramework().getTopmodel(), symVarBindings);
        }
        catch (ViatraTransformationException e) {
            throw e.addNewStackElement((EObject)callRule);
        }
        catch (Throwable t) {
            String[] context = new String[]{String.valueOf(callRule.getAsmRule().getNamespace().getFqn()) + "." + callRule.getAsmRule().getFqn(), t.getMessage()};
            throw new ASMInterpreterException("Fatal Exception occured during the execution of the invoked {1} Native ASM rule with the following message: \n {2}", context, (AnnotatedElement)callRule);
        }
        if (result) {
            int i = 0;
            while (i < callRule.getActualParameters().size()) {
                if (!((SymbolicRuleParameter)symParams.get(i)).getDirection().equals((Object)DirectionKind.IN_LITERAL)) {
                    Variable sym = ((SymbolicRuleParameter)symParams.get(i)).getVariable();
                    outVarBindings.put(sym, ((VariableReference)callRule.getActualParameters().get(i)).getVariable());
                }
                ++i;
            }
        }
        for (Object symbolicVariable : outVarBindings.keySet()) {
            try {
                executionEnvironment.setVariableValue((Variable)outVarBindings.get(symbolicVariable), TermEvaluator.getInstance().isASMNativeType(symVarBindings.get(symbolicVariable)) != false ? symVarBindings.get(symbolicVariable) : new JavaNativeValue(symVarBindings.get(symbolicVariable)));
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{((Variable)symbolicVariable).getName(), String.valueOf(callRule.getAsmRule().getNamespace().getFqn()) + "." + callRule.getAsmRule().getFqn(), e.getMessage()};
                throw new ASMInterpreterException("Error at setting the value of the {1} variable after returning from the {2} native ASM rule call: {3}", context, (AnnotatedElement)callRule);
            }
        }
        return result;
    }
}

