/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.ArithmeticOperationEvaluator;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.BasicTermEvaluator;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.ConversionOperationEvaluator;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.JavaNativeValue;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.ModelElementQueryEvaluator;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.RelationalOperationEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ModelElementQuery;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ArithmeticOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ConversionOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.RelationalOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Multiplicity;

public class TermEvaluator {
    private static TermEvaluator _instance = new TermEvaluator();

    TermEvaluator() {
    }

    public static TermEvaluator getInstance() {
        return _instance;
    }

    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        if (termToBeEvaluated instanceof ArithmeticOperation) {
            return ArithmeticOperationEvaluator.getInstance().evaluate(executionEnvironment, termToBeEvaluated);
        }
        if (termToBeEvaluated instanceof ConversionOperation) {
            return ConversionOperationEvaluator.getInstance().evaluate(executionEnvironment, termToBeEvaluated);
        }
        if (termToBeEvaluated instanceof RelationalOperation) {
            return RelationalOperationEvaluator.getInstance().evaluate(executionEnvironment, termToBeEvaluated);
        }
        if (termToBeEvaluated instanceof ModelElementQuery) {
            return ModelElementQueryEvaluator.getInstance().evaluate(executionEnvironment, termToBeEvaluated);
        }
        if (termToBeEvaluated == null) {
            return ValueKind.UNDEF_LITERAL;
        }
        return BasicTermEvaluator.getInstance().evaluate(executionEnvironment, termToBeEvaluated);
    }

    public Boolean isASMNativeType(Object o) {
        if (o instanceof String || o instanceof Integer || o instanceof Double || o instanceof Boolean || o instanceof Multiplicity || ValueKind.UNDEF_LITERAL.equals(o) || o instanceof IModelElement) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected String convertToJavaType(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "String";
        }
        if (obj instanceof Integer) {
            return "Integer";
        }
        if (obj instanceof Double) {
            return "Double";
        }
        if (obj instanceof Boolean) {
            return "Boolean";
        }
        if (obj instanceof Multiplicity) {
            return "Multiplicity";
        }
        if (ValueKind.UNDEF_LITERAL.equals(obj)) {
            return "UNDEF";
        }
        if (obj instanceof IRelation) {
            return "Relation (ModelElement)";
        }
        if (obj instanceof IEntity) {
            return "Entity (ModelElement)";
        }
        if (obj instanceof JavaNativeValue) {
            return "JavaNativeValue";
        }
        return "unknown type";
    }

    public String convertValueKindtoJavaType(ValueKind type) {
        if (type == null) {
            return "null";
        }
        if (type.equals((Object)ValueKind.BOOLEAN_LITERAL)) {
            return "Boolean";
        }
        if (type.equals((Object)ValueKind.DOUBLE_LITERAL)) {
            return "Double";
        }
        if (type.equals((Object)ValueKind.INTEGER_LITERAL)) {
            return "Integer";
        }
        if (type.equals((Object)ValueKind.MODELELEMENT_LITERAL)) {
            return "EObject";
        }
        if (type.equals((Object)ValueKind.MULTIPLICITY_LITERAL)) {
            return "[Multiplicity]";
        }
        if (type.equals((Object)ValueKind.STRING_LITERAL)) {
            return "String";
        }
        if (type.equals((Object)ValueKind.UNDEF_LITERAL)) {
            return "Object";
        }
        return "error: unknown type";
    }
}

