/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MultiplicityKind implements Enumerator
{
    ONE_TO_ONE_LITERAL(0, "one_to_one", "one_to_one"),
    ONE_TO_MANY_LITERAL(1, "one_to_many", "one_to_many"),
    MANY_TO_ONE_LITERAL(2, "many_to_one", "many_to_one"),
    MANY_TO_MANY_LITERAL(3, "many_to_many", "many_to_many");

    public static final String copyright = " * Copyright (c) 2006-2010 Istvan Rath and Daniel Varro\r\n * All rights reserved. This program and the accompanying materials\r\n * are made available under the terms of the Eclipse Public License v1.0\r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/epl-v10.html\r\n *\r\n * Contributors:\r\n *    Istvan Rath, Daniel Varro - initial API and implementation\r\n";
    public static final int ONE_TO_ONE = 0;
    public static final int ONE_TO_MANY = 1;
    public static final int MANY_TO_ONE = 2;
    public static final int MANY_TO_MANY = 3;
    private static final MultiplicityKind[] VALUES_ARRAY;
    public static final List<MultiplicityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MultiplicityKind[]{ONE_TO_ONE_LITERAL, ONE_TO_MANY_LITERAL, MANY_TO_ONE_LITERAL, MANY_TO_MANY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MultiplicityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MultiplicityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MultiplicityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MultiplicityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MultiplicityKind get(int value) {
        switch (value) {
            case 0: {
                return ONE_TO_ONE_LITERAL;
            }
            case 1: {
                return ONE_TO_MANY_LITERAL;
            }
            case 2: {
                return MANY_TO_ONE_LITERAL;
            }
            case 3: {
                return MANY_TO_MANY_LITERAL;
            }
        }
        return null;
    }

    private MultiplicityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

