/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTRuleBuildingException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTElementMapping;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.GTOperationContext;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.PatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.logger.Logger;

public class RightHandSideMatcher
extends PatternMatcher {
    private FlattenedPattern flattenedPattern;

    RightHandSideMatcher(GTPattern pattern, Logger logger, IModelManager manager, ITermHandler termHandler) throws ViatraTransformationException {
        super(pattern, logger, manager, termHandler);
        try {
            this.flattenedPattern = this.root.getSingleFlattenedPattern();
        }
        catch (PatternMatcherCompileTimeException e) {
            throw e.addNewStackElement((EObject)pattern);
        }
    }

    public MatchingFrame generateMatchingFrameofInputContext(Collection<GTElementMapping> gtElementMappings, Object[] inputMapping, PatternCallSignature[] signature) throws GTRuleBuildingException {
        if (inputMapping.length != signature.length) {
            throw new GTRuleBuildingException("[INTERNAL ERROR] The number of input parameter's mappingd and do not match the number of signature element.", null, null);
        }
        MatchingFrame template = new MatchingFrame(this.flattenedPattern);
        int i = 0;
        while (i < inputMapping.length) {
            if (signature[i].getParameterMode() == ParameterMode.OUTPUT) {
                if (inputMapping[i] != null && !inputMapping[i].equals(ValueKind.UNDEF_LITERAL)) {
                    this.logger.debug("Parameter " + i + " is an output parameter with value " + inputMapping[i].toString());
                }
            } else if (signature[i].getParameterMode() == ParameterMode.INPUT) {
                if (inputMapping[i] != null) {
                    template.testAndSetValue(i, inputMapping[i]);
                } else {
                    throw new GTRuleBuildingException("[INTERNAL ERROR] Input parameter without value (NULL)", null, null);
                }
            }
            ++i;
        }
        return template;
    }

    public GTOperationContext generateGTOperation(Collection<GTElementMapping> gtElementMappings, PatternCallSignature[] signature) throws GTRuleBuildingException {
        GTOperationContext finalOperations = this.flattenedPattern.getSearchGraph().generateGTOperations(gtElementMappings, this.manager, signature);
        return finalOperations;
    }
}

