/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateConstant2Bound;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CreateRelationConstant2Bound
extends CreateConstant2Bound {
    ConstantSearchGraphNode sourceNode;

    public CreateRelationConstant2Bound(ConstantSearchGraphNode s, int t, int variableI, IModelManager manager) {
        super(manager, variableI);
        this.sourceNode = s;
        this.source = manager.getElementByName(s.getElement());
        this.target = t;
    }

    @Override
    protected boolean create(MatchingFrame frame) throws GTOperationException {
        IModelElement targetElement = null;
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.target).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, frame.getPattern().getSearchGraph().getSearchNode(this.target).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.source == null) {
            String[] context = new String[]{this.sourceNode.getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.sourceNode.getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (targetElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.target).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.target).getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            frame.setValue(this.variableIndex, this.manager.newRelation(this.source, targetElement));
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] Relation '{1}' creation failed due to: {2}", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source.getName() + " -- Relation:" + this.variableIndex + " -> " + this.target;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

