/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateBound2Bound;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CreateSuperTypeofBound2Bound
extends CreateBound2Bound {
    private SearchGraphEdge relatedSearchGraphEdge;

    public CreateSuperTypeofBound2Bound(int s, int t, IModelManager manager, SearchGraphEdge edge) {
        super(manager);
        this.target = t;
        this.source = s;
        this.relatedSearchGraphEdge = edge;
    }

    @Override
    protected boolean create(MatchingFrame frame) throws GTOperationException {
        IModelElement sourceElement = null;
        IModelElement targetElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (sourceElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (targetElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            this.manager.newSupertypeOf(sourceElement, targetElement);
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.source).getName(), frame.getPattern().getSearchGraph().getSearchNode(this.target).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] Inheritance creation failed, between SuperType: '{1}' and Subtype '{2}' due to: {3}", context, this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source + " -- Supertypeof: -> " + this.target;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

