/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.ISearchGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.EdgeTypeinAlgorithm;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.PseudoSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNodeComparator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.VariableSearchGraphNode;

public class ChuiEdmonds {
    int min;
    int finalizedVertexId = -1;
    ArrayList<SearchGraphNode> sSet = new ArrayList();

    public ChuiEdmonds(IModelManager manager) {
        this.sSet.clear();
        this.finalizedVertexId = -1;
        this.min = Integer.MAX_VALUE;
    }

    public void init() {
        this.sSet.clear();
        this.finalizedVertexId = -1;
        this.min = Integer.MAX_VALUE;
    }

    public SearchGraphNode[] evaluateSearchPlan(ISearchGraph iSearchGraph) {
        return this.evaluateSearchPlanInner(this.evaluateSearchTreeInner(iSearchGraph.getSearchNodes().values()));
    }

    private Collection<SearchGraphNode> evaluateSearchTreeInner(Collection<SearchGraphNode> nodes) {
        for (SearchGraphNode node : nodes) {
            if (!(node instanceof VariableSearchGraphNode) || ((VariableSearchGraphNode)node).isInput()) continue;
            this.min = Integer.MAX_VALUE;
            for (SearchGraphEdge edge : node.getSources()) {
                if (edge.getWeight() >= this.min) continue;
                this.min = edge.getWeight();
                if (node.getTreeEdge() != null) {
                    node.getTreeEdge().getSourceNode().decreaseOutgoingTreeEdgeNumber();
                    node.getTreeEdge().setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.FREE);
                }
                node.setTreeEdge(edge);
                edge.getSourceNode().increaseOutgonigTreeEdgeNumber();
                edge.setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.TREE);
            }
        }
        for (SearchGraphNode node : nodes) {
            if (this.sSet.contains(node)) continue;
            this.findCircle(node);
        }
        this.eraseCircles();
        return nodes;
    }

    SearchGraphNode getVirtualVertex(SearchGraphNode node) {
        if (node == null) {
            return null;
        }
        SearchGraphNode virtualnode = node;
        if (node.getVirtualSearchGraphNode() == null) {
            return node;
        }
        virtualnode = node;
        while (virtualnode.getVirtualSearchGraphNode() != null) {
            virtualnode = virtualnode.getVirtualSearchGraphNode();
        }
        return virtualnode;
    }

    private void findCircle(SearchGraphNode node) {
        SearchGraphNode actualNode = node;
        SearchGraphNode previousNode = node;
        while (previousNode != null && !this.sSet.contains(previousNode)) {
            this.sSet.add(previousNode);
            actualNode = previousNode;
            previousNode = actualNode.getTreeEdge() != null ? this.getVirtualVertex(actualNode.getTreeEdge().getSourceNode()) : null;
        }
        if (previousNode != null && this.finalizedVertexId < this.sSet.indexOf(previousNode)) {
            this.evaluateNewEdgeWeights(actualNode, previousNode);
        } else {
            this.finalizedVertexId = this.sSet.size() - 1;
        }
    }

    private void evaluateNewEdgeWeights(SearchGraphNode circleBeginNode, SearchGraphNode circleEndNode) {
        int pseudoNodeId;
        int minEdgeWeight = Integer.MAX_VALUE;
        int minIncomingEdgeWeight = Integer.MAX_VALUE;
        int smallestId = pseudoNodeId = this.sSet.size();
        PseudoSearchGraphNode pseudoNode = new PseudoSearchGraphNode();
        SearchGraphEdge minIncomingEdge = null;
        SearchGraphNode actualNode = circleBeginNode;
        pseudoNode.setCircleBiggestId(pseudoNodeId - 1);
        do {
            if (actualNode.getTreeEdge().getWeight() < minEdgeWeight) {
                minEdgeWeight = actualNode.getTreeEdge().getWeight();
            }
            if (this.sSet.indexOf(actualNode) < smallestId) {
                smallestId = this.sSet.indexOf(actualNode);
            }
            if (actualNode instanceof PseudoSearchGraphNode && ((PseudoSearchGraphNode)actualNode).getCircleSmallestId() < smallestId) {
                smallestId = ((PseudoSearchGraphNode)actualNode).getCircleSmallestId();
            }
            actualNode.getTreeEdge().setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.CIRCLE);
        } while (!(actualNode = this.getVirtualVertex(actualNode.getTreeEdge().getSourceNode())).equals(circleBeginNode));
        actualNode = circleBeginNode;
        pseudoNode.setCircleSmallestId(smallestId);
        do {
            for (SearchGraphEdge edge : actualNode.getSources()) {
                if (this.getVirtualVertex(edge.getSourceNode()).getTreeEdge() != null && (edge.getEdgeTypeinAlgorithm() != EdgeTypeinAlgorithm.FREE || this.getVirtualVertex(edge.getSourceNode()).getTreeEdge().getEdgeTypeinAlgorithm() == EdgeTypeinAlgorithm.CIRCLE)) continue;
                edge.setWeight(edge.getWeight() + minEdgeWeight - actualNode.getTreeEdge().getWeight());
                if (edge.getWeight() < minIncomingEdgeWeight) {
                    minIncomingEdge = edge;
                    minIncomingEdgeWeight = edge.getWeight();
                }
                pseudoNode.addSource(edge);
            }
        } while (!(actualNode = this.getVirtualVertex(actualNode.getTreeEdge().getSourceNode())).equals(circleBeginNode));
        actualNode = this.getVirtualVertex(circleBeginNode.getTreeEdge().getSourceNode());
        circleBeginNode.setVirtualSearchGraphNode(pseudoNode);
        circleBeginNode = pseudoNode;
        SearchGraphNode previousNode = null;
        while (!actualNode.equals(circleBeginNode)) {
            previousNode = actualNode;
            actualNode = this.getVirtualVertex(actualNode.getTreeEdge().getSourceNode());
            previousNode.setVirtualSearchGraphNode(pseudoNode);
        }
        previousNode = null;
        if (minIncomingEdge != null) {
            pseudoNode.setTreeEdge(minIncomingEdge);
            minIncomingEdge.setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.TREE);
        }
        pseudoNode.setName("pseudo" + pseudoNodeId);
        this.findCircle(pseudoNode);
    }

    private void eraseCircles() {
        int i = this.sSet.size() - 1;
        while (i > -1) {
            if (this.sSet.get(i) instanceof PseudoSearchGraphNode && !((PseudoSearchGraphNode)this.sSet.get(i)).isBlocked()) {
                PseudoSearchGraphNode pnode = (PseudoSearchGraphNode)this.sSet.get(i);
                SearchGraphEdge pedge = pnode.getTreeEdge();
                int coverNodeId = this.sSet.indexOf(pedge.getTargetNode());
                pedge.getTargetNode().getTreeEdge().setEdgeTypeinAlgorithm(EdgeTypeinAlgorithm.FREE);
                pedge.getTargetNode().getTreeEdge().getSourceNode().decreaseOutgoingTreeEdgeNumber();
                pedge.getTargetNode().setTreeEdge(pedge);
                pedge.getSourceNode().increaseOutgonigTreeEdgeNumber();
                int j = coverNodeId;
                while (j < i) {
                    PseudoSearchGraphNode innerPseudoNode;
                    if (this.sSet.get(j) instanceof PseudoSearchGraphNode && coverNodeId >= (innerPseudoNode = (PseudoSearchGraphNode)this.sSet.get(j)).getCircleSmallestId() && coverNodeId <= innerPseudoNode.getCircleBiggestId()) {
                        innerPseudoNode.setBlocked(true);
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private SearchGraphNode[] evaluateSearchPlanInner(Collection<SearchGraphNode> nodes) {
        block8: {
            maxNode = null;
            max = -2147483648;
            indexOfSearchPlan = nodes.size() - 1;
            indexOfInputParameters = -1;
            searchPlan = new SearchGraphNode[nodes.size()];
            comparator = new SearchGraphNodeComparator();
            for (SearchGraphNode node : nodes) {
                if (!(node instanceof VariableSearchGraphNode) || !((VariableSearchGraphNode)node).isInput()) continue;
                searchPlan[++indexOfInputParameters] = node;
                node.setChecked(true);
                if (node.getTreeEdge() == null) continue;
                node.getTreeEdge().getSourceNode().decreaseOutgoingTreeEdgeNumber();
            }
            leaves = new TreeMap<SearchGraphNode, V>(comparator);
            for (SearchGraphNode node : nodes) {
                if (node.getOutgoingTreeEdgeNumber() != 0 || node instanceof VariableSearchGraphNode && ((VariableSearchGraphNode)node).isInput()) continue;
                leaves.put(node, null);
                if (node.getTreeEdge() == null || max >= node.getTreeEdge().getOldWeight()) continue;
                max = node.getTreeEdge().getOldWeight();
                maxNode = node;
            }
            if (maxNode != null) ** GOTO lbl44
            while (indexOfSearchPlan != indexOfInputParameters) {
                searchPlan[indexOfSearchPlan] = maxNode = leaves.lastKey();
                --indexOfSearchPlan;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                searchPlan[indexOfSearchPlan] = maxNode;
                if (maxNode.getTreeEdge() != null) {
                    maxNode.getTreeEdge().getSourceNode().decreaseOutgoingTreeEdgeNumber();
                    if (!(maxNode.getTreeEdge().getSourceNode().getOutgoingTreeEdgeNumber() != 0 || maxNode.getTreeEdge().getSourceNode() instanceof VariableSearchGraphNode && ((VariableSearchGraphNode)maxNode.getTreeEdge().getSourceNode()).isInput())) {
                        leaves.put(maxNode.getTreeEdge().getSourceNode(), null);
                    }
                }
                leaves.remove(maxNode);
                try {
                    if (leaves.isEmpty()) break;
                    maxNode = leaves.lastKey();
                }
                catch (NoSuchElementException v0) {
                    break;
                }
                --indexOfSearchPlan;
lbl44:
                // 2 sources

                ** while (indexOfSearchPlan != indexOfInputParameters)
            }
        }
        return searchPlan;
    }
}

