/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class IsEntityorRelationCheckOperation
extends CheckOperation {
    private Integer source;
    private SearchGraphEdge relatedSearchGraphEdge;
    private String type;

    public IsEntityorRelationCheckOperation(Integer source, SearchGraphEdge edge, String type) {
        this.source = source;
        this.relatedSearchGraphEdge = edge;
        this.type = type;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        IModelElement sourceElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (sourceElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if ("vpm.entity".equals(this.type)) {
            return sourceElement.isEntity();
        }
        if ("vpm.relation".equals(this.type)) {
            return sourceElement.isRelation();
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.type + "-- " + this.relatedSearchGraphEdge.getVPMEdgeType().name() + "- CHECK -> " + this.source;
    }

    @Override
    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

