/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers;

import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.TypeHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.ITypeInfoProviderConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.Equality;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.Inequality;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.TypeUnary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;

public class LayoutHelper {
    public static <PatternDescription, StubHandle, Collector> void unifyVariablesAlongEqualities(PSystem<PatternDescription, StubHandle, Collector> pSystem) {
        Set<Equality> equals = pSystem.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (equality.isMoot()) continue;
            equality.getWho().unifyInto(equality.getWithWhom());
        }
    }

    public static <PatternDescription, StubHandle, Collector> void eliminateWeakInequalities(PSystem<PatternDescription, StubHandle, Collector> pSystem) {
        for (Inequality inequality : pSystem.getConstraintsOfType(Inequality.class)) {
            inequality.eliminateWeak();
        }
    }

    public static <PatternDescription, StubHandle, Collector> void eliminateInferrableUnaryTypes(PSystem<PatternDescription, StubHandle, Collector> pSystem, IPatternMatcherContext<PatternDescription> context) {
        Set<TypeUnary> constraintsOfType = pSystem.getConstraintsOfType(TypeUnary.class);
        block0: for (TypeUnary typeUnary : constraintsOfType) {
            PVariable var = (PVariable)typeUnary.getVariablesTuple().get(0);
            Object expressedType = typeUnary.getTypeInfo(var);
            Set<ITypeInfoProviderConstraint> typeRestrictors = var.getReferringConstraintsOfType(ITypeInfoProviderConstraint.class);
            typeRestrictors.remove(typeUnary);
            for (ITypeInfoProviderConstraint iTypeRestriction : typeRestrictors) {
                Set<Object> typeClosure;
                Object typeInfo = iTypeRestriction.getTypeInfo(var);
                if (typeInfo == ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED || !(typeClosure = TypeHelper.typeClosure(Collections.singleton(typeInfo), context)).contains(expressedType)) continue;
                typeUnary.delete();
                continue block0;
            }
        }
    }

    public static <PatternDescription, StubHandle, Collector> void checkSanity(PSystem<PatternDescription, StubHandle, Collector> pSystem) throws RetePatternBuildException {
        for (PConstraint pConstraint : pSystem.getConstraints()) {
            pConstraint.checkSanity();
        }
    }

    public static <PatternDescription, StubHandle, Collector> PConstraint getAnyUnenforcedConstraint(PSystem<PatternDescription, StubHandle, Collector> pSystem, Stub<StubHandle> stub) {
        Set<PConstraint> allEnforcedConstraints = stub.getAllEnforcedConstraints();
        Set<PConstraint> constraints = pSystem.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (allEnforcedConstraints.contains(pConstraint)) continue;
            return pConstraint;
        }
        return null;
    }

    public static <PatternDescription, StubHandle, Collector> void finalCheck(PSystem<PatternDescription, StubHandle, Collector> pSystem, Stub<StubHandle> stub) throws RetePatternBuildException {
        PConstraint unenforcedConstraint = LayoutHelper.getAnyUnenforcedConstraint(pSystem, stub);
        if (unenforcedConstraint != null) {
            throw new RetePatternBuildException("Pattern matcher construction terminated without successfully enforcing constraint {1}.", new String[]{unenforcedConstraint.toString()}, null);
        }
        for (ExportedParameter export : pSystem.getConstraintsOfType(ExportedParameter.class)) {
            if (export.isReadyAt(stub)) continue;
            throw new RetePatternBuildException("Exported parameter {1} was lost during construction.", new String[]{export.getParameterName()}, null);
        }
    }
}

