/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;

public class Equality<PatternDescription, StubHandle>
extends DeferredPConstraint<PatternDescription, StubHandle> {
    private PVariable who;
    private PVariable withWhom;

    public Equality(PSystem<PatternDescription, StubHandle, ?> pSystem, PVariable who, PVariable withWhom) {
        super(pSystem, Equality.buildSet(who, withWhom));
        this.who = who;
        this.withWhom = withWhom;
    }

    private static Set<PVariable> buildSet(PVariable who, PVariable withWhom) {
        HashSet<PVariable> set = new HashSet<PVariable>();
        set.add(who);
        set.add(withWhom);
        return set;
    }

    public boolean isMoot() {
        return this.who.equals(this.withWhom);
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.who)) {
            this.who = replacement;
        }
        if (obsolete.equals(this.withWhom)) {
            this.withWhom = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(this.who.getName()) + "=" + this.withWhom.getName();
    }

    public PVariable getWho() {
        return this.who;
    }

    public PVariable getWithWhom() {
        return this.withWhom;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReadyAt(Stub<StubHandle> stub) {
        return stub.getVariablesIndex().containsKey(this.who) && stub.getVariablesIndex().containsKey(this.withWhom);
    }

    @Override
    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        if (this.isMoot()) {
            return stub;
        }
        Integer index1 = stub.getVariablesIndex().get(this.who);
        Integer index2 = stub.getVariablesIndex().get(this.withWhom);
        if (index1 != null && index2 != null) {
            if (index1.equals(index2)) {
                return stub;
            }
            return this.buildable.buildEqualityChecker(stub, new int[]{index1, index2});
        }
        return null;
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        String[] args = new String[]{this.who.toString(), this.withWhom.toString()};
        String msg = "Cannot express equality of variables {1} and {2} if neither of them is deducable.";
        throw new RetePatternBuildException(msg, args, null);
    }
}

