/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IndexerListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.StandardIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.StandardNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.LeftInheritanceTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public abstract class AggregatorNode
extends StandardNode {
    ProjectionIndexer projection;
    AggregatorNode me = this;
    AggregatorOuterIndexer aggregatorOuterIndexer = null;
    AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexers = null;

    public AggregatorNode(ReteContainer reteContainer, ProjectionIndexer projection) {
        super(reteContainer);
        this.projection = projection;
        projection.attachListener(new IndexerListener(){

            @Override
            public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                AggregatorNode.this.aggregateUpdate(direction, updateElement, signature, change);
            }
        });
    }

    public abstract Object aggregateGroup(Tuple var1, Collection<Tuple> var2);

    public abstract Object[] aggregateGroupBeforeAndNow(Tuple var1, Collection<Tuple> var2, Direction var3, Tuple var4, boolean var5);

    protected Tuple aggregateAndPack(Tuple signature, Collection<Tuple> group) {
        return this.packResult(signature, this.aggregateGroup(signature, group));
    }

    public AggregatorOuterIndexer getAggregatorOuterIndexer() {
        if (this.aggregatorOuterIndexer == null) {
            this.aggregatorOuterIndexer = new AggregatorOuterIndexer();
        }
        return this.aggregatorOuterIndexer;
    }

    public AggregatorOuterIdentityIndexer getAggregatorOuterIdentityIndexer(int resultPositionInSignature) {
        if (this.aggregatorOuterIdentityIndexers == null) {
            this.aggregatorOuterIdentityIndexers = new AggregatorOuterIdentityIndexer[this.projection.getMask().indices.length + 1];
        }
        if (this.aggregatorOuterIdentityIndexers[resultPositionInSignature] == null) {
            this.aggregatorOuterIdentityIndexers[resultPositionInSignature] = new AggregatorOuterIdentityIndexer(resultPositionInSignature);
        }
        return this.aggregatorOuterIdentityIndexers[resultPositionInSignature];
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.reteContainer.flushUpdates();
        for (Tuple signature : this.projection.getSignatures()) {
            collector.add(this.aggregateAndPack(signature, this.projection.get(signature)));
        }
    }

    protected Tuple packResult(Tuple signature, Object result) {
        Object[] resultArray = new Object[]{result};
        return new LeftInheritanceTuple(signature, resultArray);
    }

    protected void aggregateUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        Collection<Tuple> currentGroup = this.projection.get(signature);
        Object[] aggregatedResults = this.aggregateGroupBeforeAndNow(signature, currentGroup, direction, updateElement, change);
        this.propagate(Direction.REVOKE, this.packResult(signature, aggregatedResults[0]), signature);
        this.propagate(Direction.INSERT, this.packResult(signature, aggregatedResults[1]), signature);
    }

    protected void propagate(Direction direction, Tuple packResult, Tuple signature) {
        this.propagateUpdate(direction, packResult);
        if (this.aggregatorOuterIndexer != null) {
            this.aggregatorOuterIndexer.propagate(direction, packResult, signature);
        }
        if (this.aggregatorOuterIdentityIndexers != null) {
            AggregatorOuterIdentityIndexer[] aggregatorOuterIdentityIndexerArray = this.aggregatorOuterIdentityIndexers;
            int n = this.aggregatorOuterIdentityIndexers.length;
            int n2 = 0;
            while (n2 < n) {
                AggregatorOuterIdentityIndexer aggregatorOuterIdentityIndexer = aggregatorOuterIdentityIndexerArray[n2];
                aggregatorOuterIdentityIndexer.propagate(direction, packResult, signature);
                ++n2;
            }
        }
    }

    class AggregatorOuterIdentityIndexer
    extends StandardIndexer {
        int resultPositionInSignature;
        TupleMask pruneResult;
        TupleMask reorder;

        public AggregatorOuterIdentityIndexer(int resultPositionInSignature) {
            super(AggregatorNode.this.me.reteContainer, AggregatorNode.this.projection.getMask());
            this.parent = AggregatorNode.this.me.projection.getParent();
            this.resultPositionInSignature = resultPositionInSignature;
            int sizeWithResult = AggregatorNode.this.projection.getMask().indices.length + 1;
            this.pruneResult = TupleMask.omit(resultPositionInSignature, sizeWithResult);
            this.reorder = resultPositionInSignature == sizeWithResult - 1 ? null : TupleMask.displace(sizeWithResult - 1, resultPositionInSignature, sizeWithResult);
        }

        @Override
        public Collection<Tuple> get(Tuple signatureWithResult) {
            Tuple prunedSignature = this.pruneResult.transform(signatureWithResult);
            Object result = AggregatorNode.this.aggregateGroup(prunedSignature, AggregatorNode.this.projection.get(prunedSignature));
            if (signatureWithResult.get(this.resultPositionInSignature).equals(result)) {
                return Collections.singleton(signatureWithResult);
            }
            return null;
        }

        public void propagate(Direction direction, Tuple packResult, Tuple signature) {
            Tuple updateElement = this.reorder == null ? packResult : this.reorder.transform(packResult);
            this.propagate(direction, updateElement, updateElement, true);
        }
    }

    class AggregatorOuterIndexer
    extends StandardIndexer {
        public AggregatorOuterIndexer() {
            super(AggregatorNode.this.me.reteContainer, AggregatorNode.this.projection.getMask());
            this.parent = AggregatorNode.this.me.projection.getParent();
        }

        @Override
        public Collection<Tuple> get(Tuple signature) {
            return Collections.singleton(AggregatorNode.this.aggregateAndPack(signature, AggregatorNode.this.projection.get(signature)));
        }

        public void propagate(Direction direction, Tuple packResult, Tuple signature) {
            this.propagate(direction, packResult, signature, true);
        }
    }
}

