/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.Collection;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IndexerListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IterableIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.StandardNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public abstract class DualInputNode
extends StandardNode {
    protected IterableIndexer primarySlot;
    protected Indexer secondarySlot;
    protected TupleMask complementerSecondaryMask;

    public DualInputNode(ReteContainer reteContainer, IterableIndexer primarySlot, Indexer secondarySlot, TupleMask complementerSecondaryMask) {
        super(reteContainer);
        this.complementerSecondaryMask = complementerSecondaryMask;
        this.primarySlot = primarySlot;
        this.secondarySlot = secondarySlot;
        final DualInputNode me = this;
        primarySlot.attachListener(new IndexerListener(){

            @Override
            public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                DualInputNode.this.notifyUpdate(Side.PRIMARY, direction, updateElement, signature, change);
            }

            public String toString() {
                return "primary@" + me;
            }
        });
        secondarySlot.attachListener(new IndexerListener(){

            @Override
            public void notifyIndexerUpdate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
                DualInputNode.this.notifyUpdate(Side.SECONDARY, direction, updateElement, signature, change);
            }

            public String toString() {
                return "secondary@" + me;
            }
        });
    }

    protected Collection<Tuple> retrieveOpposites(Side side, Tuple signature) {
        Collection<Tuple> opposites = this.getSlot(side.opposite()).get(signature);
        return opposites;
    }

    protected Tuple unify(Tuple left, Tuple right) {
        return this.complementerSecondaryMask.combine(left, right, true, true);
    }

    protected Tuple unify(Side side, Tuple ps, Tuple opposite) {
        switch (side) {
            case PRIMARY: {
                return this.unify(ps, opposite);
            }
            case SECONDARY: {
                return this.unify(opposite, ps);
            }
        }
        return null;
    }

    public abstract void notifyUpdate(Side var1, Direction var2, Tuple var3, Tuple var4, boolean var5);

    public abstract Tuple calibrate(Tuple var1, Tuple var2);

    public void setComplementerSecondaryMask(TupleMask complementerSecondaryMask) {
        this.complementerSecondaryMask = complementerSecondaryMask;
    }

    protected Indexer getSlot(Side side) {
        if (side == Side.PRIMARY) {
            return this.primarySlot;
        }
        return this.secondarySlot;
    }

    public static enum Side {
        PRIMARY,
        SECONDARY;


        public Side opposite() {
            switch (this) {
                case PRIMARY: {
                    return SECONDARY;
                }
                case SECONDARY: {
                    return PRIMARY;
                }
            }
            return PRIMARY;
        }
    }
}

