/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.StandardIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public class IdentityIndexer
extends StandardIndexer
implements ProjectionIndexer {
    Collection<Tuple> memory;

    public IdentityIndexer(ReteContainer reteContainer, int tupleWidth, Collection<Tuple> memory, Supplier parent) {
        super(reteContainer, TupleMask.identity(tupleWidth));
        this.memory = memory;
        this.parent = parent;
    }

    @Override
    public Collection<Tuple> get(Tuple signature) {
        if (this.memory.contains(signature)) {
            return Collections.singleton(signature);
        }
        return null;
    }

    @Override
    public Collection<Tuple> getSignatures() {
        return this.memory;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.memory.iterator();
    }

    @Override
    public void appendParent(Supplier supplier) {
        throw new UnsupportedOperationException("An identityIndexer allows no explicit parent nodes");
    }

    @Override
    public void removeParent(Supplier supplier) {
        throw new UnsupportedOperationException("An identityIndexer allows no explicit parent nodes");
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        throw new UnsupportedOperationException("An identityIndexer allows no explicit parent nodes");
    }

    public void propagate(Direction direction, Tuple updateElement) {
        this.propagate(direction, updateElement, updateElement, true);
    }
}

