/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.CountNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ExistenceNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.GenericProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IdentityIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IterableIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.JoinNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.NullIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.OnetimeIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.misc.ConstantNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Node;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Production;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.RemoteReceiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.RemoteSupplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.DefaultProductionNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.EqualityFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.InequalityFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.TransparentNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.TrimmerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.UniquenessEnforcerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.ValueBinderFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.util.Options;

public class Library {
    ReteContainer reteContainer;
    Map<Tuple, ProjectionIndexer> projectionIndexers;
    Map<Tuple, CountNode> countNodes;
    Map<Tuple, JoinNode> joinNodes;
    Map<Tuple, ExistenceNode> existenceNodes;
    Map<Tuple, InequalityFilterNode> ineqFilters;
    Map<Tuple, EqualityFilterNode> eqFilters;
    Map<Tuple, ValueBinderFilterNode> valueBinderFilters;
    Map<Tuple, TrimmerNode> trimmers;
    Map<Supplier, TransparentNode> transparentNodes;
    Map<Tuple, ConstantNode> constantNodes;
    Map<Supplier, RemoteReceiver> remoteReceivers;
    Map<Address<? extends Supplier>, RemoteSupplier> remoteSuppliers;

    public Library(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.projectionIndexers = new HashMap<Tuple, ProjectionIndexer>();
        this.joinNodes = new HashMap<Tuple, JoinNode>();
        this.existenceNodes = new HashMap<Tuple, ExistenceNode>();
        this.ineqFilters = new HashMap<Tuple, InequalityFilterNode>();
        this.eqFilters = new HashMap<Tuple, EqualityFilterNode>();
        this.valueBinderFilters = new HashMap<Tuple, ValueBinderFilterNode>();
        this.trimmers = new HashMap<Tuple, TrimmerNode>();
        this.transparentNodes = new HashMap<Supplier, TransparentNode>();
        this.constantNodes = new HashMap<Tuple, ConstantNode>();
        this.countNodes = new HashMap<Tuple, CountNode>();
        this.remoteReceivers = new HashMap<Supplier, RemoteReceiver>();
        this.remoteSuppliers = new HashMap<Address<? extends Supplier>, RemoteSupplier>();
    }

    synchronized RemoteReceiver accessRemoteReceiver(Address<? extends Supplier> address) {
        if (!this.reteContainer.isLocal(address)) {
            return address.getContainer().getLibrary().accessRemoteReceiver(address);
        }
        Supplier localSupplier = this.reteContainer.resolveLocal(address);
        RemoteReceiver result = this.remoteReceivers.get(localSupplier);
        if (result == null) {
            result = new RemoteReceiver(this.reteContainer);
            this.reteContainer.connect(localSupplier, result);
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.remoteReceivers.put(localSupplier, result);
            }
        }
        return result;
    }

    synchronized RemoteSupplier accessRemoteSupplier(Address<? extends Supplier> address) {
        RemoteSupplier result = this.remoteSuppliers.get(address);
        if (result == null) {
            result = new RemoteSupplier(this.reteContainer, address.getContainer().getLibrary().accessRemoteReceiver(address));
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.remoteSuppliers.put(address, result);
            }
        }
        return result;
    }

    public Supplier asSupplier(Address<? extends Supplier> address) {
        if (!this.reteContainer.isLocal(address)) {
            return this.accessRemoteSupplier(address);
        }
        return this.reteContainer.resolveLocal(address);
    }

    public Address<ProjectionIndexer> accessProjectionIndexer(Address<? extends Supplier> supplierAddress, TupleMask mask) {
        Supplier supplier = this.asSupplier(supplierAddress);
        return this.reteContainer.makeAddress(this.accessProjectionIndexer(supplier, mask));
    }

    public Address<CountNode> accessCountNode(Address<? extends Supplier> supplierAddress, TupleMask mask) {
        Supplier supplier = this.asSupplier(supplierAddress);
        return this.reteContainer.makeAddress(this.accessCountNode(supplier, mask));
    }

    public Address<? extends Indexer> accessCountOuterIndexer(Address<? extends Supplier> supplierAddress, TupleMask mask) {
        Supplier supplier = this.asSupplier(supplierAddress);
        return this.reteContainer.makeAddress(this.accessCountNode(supplier, mask).getAggregatorOuterIndexer());
    }

    public Address<? extends Indexer> accessCountOuterIdentityIndexer(Address<? extends Supplier> supplierAddress, TupleMask mask, int resultPositionInSignature) {
        Supplier supplier = this.asSupplier(supplierAddress);
        return this.reteContainer.makeAddress(this.accessCountNode(supplier, mask).getAggregatorOuterIdentityIndexer(resultPositionInSignature));
    }

    public synchronized ProjectionIndexer accessProjectionIndexer(Supplier supplier, TupleMask mask) {
        Object[] paramsArray = new Object[]{supplier.getNodeId(), mask};
        FlatTuple params = new FlatTuple(paramsArray);
        ProjectionIndexer result = this.projectionIndexers.get(params);
        if (result == null) {
            result = new GenericProjectionIndexer(this.reteContainer, mask);
            this.reteContainer.connectAndSynchronize(supplier, result);
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.projectionIndexers.put(params, result);
            }
        }
        return result;
    }

    public synchronized CountNode accessCountNode(Supplier supplier, TupleMask mask) {
        Object[] paramsArray = new Object[]{supplier.getNodeId(), mask};
        FlatTuple params = new FlatTuple(paramsArray);
        CountNode result = this.countNodes.get(params);
        if (result == null) {
            result = new CountNode(this.reteContainer, this.accessProjectionIndexer(supplier, mask));
            if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
                this.countNodes.put(params, result);
            }
        }
        return result;
    }

    public synchronized ProjectionIndexer accessProjectionIndexerOnetime(Supplier supplier, TupleMask mask) {
        if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
            return this.accessProjectionIndexer(supplier, mask);
        }
        this.reteContainer.flushUpdates();
        OnetimeIndexer result = new OnetimeIndexer(this.reteContainer, mask);
        this.reteContainer.sendConstructionUpdates(result, Direction.INSERT, this.reteContainer.pullContents(supplier));
        this.reteContainer.flushUpdates();
        return result;
    }

    public synchronized Indexer peekProjectionIndexer(Supplier supplier, TupleMask mask) {
        Object[] paramsArray = new Object[]{supplier.getNodeId(), mask};
        FlatTuple params = new FlatTuple(paramsArray);
        return this.projectionIndexers.get(params);
    }

    public synchronized Address<JoinNode> accessJoinNode(Address<? extends IterableIndexer> primaryIndexer, Address<? extends Indexer> secondaryIndexer, TupleMask complementer) {
        IterableIndexer primarySlot = this.reteContainer.resolveLocal(primaryIndexer);
        Indexer secondarySlot = this.reteContainer.resolveLocal(secondaryIndexer);
        Object[] paramsArray = new Object[]{primarySlot.getNodeId(), secondarySlot.getNodeId(), complementer};
        FlatTuple params = new FlatTuple(paramsArray);
        JoinNode result = this.joinNodes.get(params);
        if (result == null) {
            result = new JoinNode(this.reteContainer, primarySlot, secondarySlot, complementer);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.joinNodes.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<ExistenceNode> accessExistenceNode(Address<? extends IterableIndexer> primaryIndexer, Address<? extends Indexer> secondaryIndexer, boolean negative) {
        IterableIndexer primarySlot = this.reteContainer.resolveLocal(primaryIndexer);
        Indexer secondarySlot = this.reteContainer.resolveLocal(secondaryIndexer);
        Object[] paramsArray = new Object[]{primarySlot.getNodeId(), secondarySlot.getNodeId(), negative};
        FlatTuple params = new FlatTuple(paramsArray);
        ExistenceNode result = this.existenceNodes.get(params);
        if (result == null) {
            result = new ExistenceNode(this.reteContainer, primarySlot, secondarySlot, negative);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.existenceNodes.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<InequalityFilterNode> accessInequalityFilterNode(Address<? extends Supplier> supplierAddress, int subject, TupleMask inequalityMask) {
        Supplier supplier = this.asSupplier(supplierAddress);
        Object[] paramsArray = new Object[]{supplier.getNodeId(), subject, inequalityMask};
        FlatTuple params = new FlatTuple(paramsArray);
        InequalityFilterNode result = this.ineqFilters.get(params);
        if (result == null) {
            result = new InequalityFilterNode(this.reteContainer, subject, inequalityMask);
            this.reteContainer.connect(supplier, result);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.ineqFilters.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<ValueBinderFilterNode> accessValueBinderFilterNode(Address<? extends Supplier> supplierAddress, int bindingIndex, Object bindingValue) {
        Supplier supplier = this.asSupplier(supplierAddress);
        Object[] paramsArray = new Object[]{supplier.getNodeId(), bindingIndex, bindingValue};
        FlatTuple params = new FlatTuple(paramsArray);
        ValueBinderFilterNode result = this.valueBinderFilters.get(params);
        if (result == null) {
            result = new ValueBinderFilterNode(this.reteContainer, bindingIndex, bindingValue);
            this.reteContainer.connect(supplier, result);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.valueBinderFilters.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<EqualityFilterNode> accessEqualityFilterNode(Address<? extends Supplier> supplierAddress, int[] indices) {
        Supplier supplier = this.asSupplier(supplierAddress);
        Object[] paramsArray = new Object[]{supplier.getNodeId(), new FlatTuple((Object)indices)};
        FlatTuple params = new FlatTuple(paramsArray);
        EqualityFilterNode result = this.eqFilters.get(params);
        if (result == null) {
            result = new EqualityFilterNode(this.reteContainer, indices);
            this.reteContainer.connect(supplier, result);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.eqFilters.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<TrimmerNode> accessTrimmerNode(Address<? extends Supplier> supplierAddress, TupleMask mask) {
        Supplier supplier = this.asSupplier(supplierAddress);
        Object[] paramsArray = new Object[]{supplier.getNodeId(), mask};
        FlatTuple params = new FlatTuple(paramsArray);
        TrimmerNode result = this.trimmers.get(params);
        if (result == null) {
            result = new TrimmerNode(this.reteContainer, mask);
            this.reteContainer.connect(supplier, result);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.trimmers.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<TransparentNode> accessTransparentNode(Address<? extends Supplier> supplierAddress) {
        Supplier supplier = this.asSupplier(supplierAddress);
        Supplier params = supplier;
        TransparentNode result = this.transparentNodes.get(params);
        if (result == null) {
            result = new TransparentNode(this.reteContainer);
            this.reteContainer.connect(supplier, result);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.transparentNodes.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized Address<ConstantNode> accessConstantNode(Tuple constants) {
        Tuple params = constants;
        ConstantNode result = this.constantNodes.get(params);
        if (result == null) {
            result = new ConstantNode(this.reteContainer, constants);
            if (Options.nodeSharingOption == Options.NodeSharingOption.ALL) {
                this.constantNodes.put(params, result);
            }
        }
        return this.reteContainer.makeAddress(result);
    }

    public synchronized void registerSpecializedProjectionIndexer(Node node, ProjectionIndexer indexer) {
        if (Options.nodeSharingOption != Options.NodeSharingOption.NEVER) {
            Object[] paramsArray = new Object[]{node.getNodeId(), indexer.getMask()};
            FlatTuple params = new FlatTuple(paramsArray);
            this.projectionIndexers.put(params, indexer);
        }
    }

    public synchronized Address<UniquenessEnforcerNode> newUniquenessEnforcerNode(int tupleWidth, Object tag) {
        UniquenessEnforcerNode node = new UniquenessEnforcerNode(this.reteContainer, tupleWidth);
        node.setTag(tag);
        Address<UniquenessEnforcerNode> address = this.reteContainer.makeAddress(node);
        NullIndexer nullIndexer = node.getNullIndexer();
        this.registerSpecializedProjectionIndexer(node, nullIndexer);
        IdentityIndexer identityIndexer = node.getIdentityIndexer();
        this.registerSpecializedProjectionIndexer(node, identityIndexer);
        return address;
    }

    public synchronized Address<? extends Production> newProductionNode(HashMap<Object, Integer> posMapping, Object tag) {
        DefaultProductionNode node = new DefaultProductionNode(this.reteContainer, posMapping);
        node.setTag(tag);
        Address<DefaultProductionNode> address = this.reteContainer.makeAddress(node);
        NullIndexer nullIndexer = node.getNullIndexer();
        this.registerSpecializedProjectionIndexer(node, nullIndexer);
        IdentityIndexer identityIndexer = node.getIdentityIndexer();
        this.registerSpecializedProjectionIndexer(node, identityIndexer);
        return address;
    }
}

