/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental;

import org.eclipse.viatra2.framework.properties.VIATRAPropertyKind;
import org.eclipse.viatra2.framework.properties.providers.DefaultPropertyProvider;

public class IncrementalPMPropertyProvider
extends DefaultPropertyProvider {
    public static final String VIATRA_INCREMENTAL_PROVIDER_ID = "Incremental Pattern Matcher";
    public static final String PROP_THREADS = "Number of parallel threads";

    public IncrementalPMPropertyProvider() {
        super(VIATRA_INCREMENTAL_PROVIDER_ID);
    }

    public void init() {
        this.allids.add(PROP_THREADS);
    }

    public String getDefaultPropertyValue(String id) {
        if (id.equals(PROP_THREADS)) {
            return "0";
        }
        return "default";
    }

    public VIATRAPropertyKind getPropertyKind(String id) {
        return VIATRAPropertyKind.STRING;
    }

    public boolean isActive() {
        return true;
    }

    public static Integer interpretThreads(String threadStr) {
        Integer threads;
        block3: {
            threads = null;
            try {
                threads = Integer.parseInt(threadStr);
            }
            catch (NumberFormatException numberFormatException) {
                String lcThreads = threadStr.toLowerCase();
                if ("true".equals(lcThreads) || "parallel".equals(lcThreads)) {
                    threads = 1;
                }
                if (!"auto".equals(lcThreads)) break block3;
                threads = Runtime.getRuntime().availableProcessors();
            }
        }
        return threads;
    }
}

