/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.hardwired;

import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class HardwiredTransitiveClosure<StubHandle, Collector> {
    protected GTASMBuildable<StubHandle, Collector> buildable;
    protected IPatternMatcherContext<GTPattern> context;
    protected GTPattern gtPattern;
    protected GTPattern ofPattern;
    protected Collector prodNode;

    public HardwiredTransitiveClosure(GTASMBuildable<StubHandle, Collector> buildable, IPatternMatcherContext<GTPattern> context, GTPattern gtPattern, GTPattern ofPattern, Collector prodNode) {
        this.buildable = buildable.putOnTab(gtPattern);
        this.context = context;
        this.gtPattern = gtPattern;
        this.prodNode = prodNode;
    }

    public Collector run() throws RetePatternBuildException {
        EList symParameters = this.gtPattern.getSymParameters();
        if (symParameters.size() != 2) {
            throw new RetePatternBuildException("Pattern {1} is annotated as transitiveClosure, should have two arguments", new String[]{this.gtPattern.getFqn()}, (Object)this.gtPattern);
        }
        if (this.ofPattern.getSymParameters().size() != 2) {
            throw new RetePatternBuildException("Pattern {1} is annotated as transitiveClosure, 'ofPattern' [2] have two arguments", new String[]{this.gtPattern.getFqn(), this.ofPattern.getFqn()}, (Object)this.gtPattern);
        }
        Stub ofPatternStub = this.buildable.patternCallStub((Tuple)new FlatTuple(symParameters.toArray()), this.ofPattern);
        Stub transitiveClosure = this.buildable.buildTransitiveClosure(ofPatternStub);
        this.buildable.buildConnection(transitiveClosure, this.prodNode);
        return this.prodNode;
    }
}

