/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.BaseTypeSafePredicateCheck;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.GTPatternBodyToPSystem;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.FunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ModelElementQuery;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class GTASMCheckConditionPConstraint<StubHandle>
extends BaseTypeSafePredicateCheck<GTPattern, StubHandle> {
    private Term topTerm;
    private GTPatternBodyToPSystem<StubHandle, ?> pGraph;
    private GTASMBuildable<StubHandle, ?> gtBuildable;

    public GTASMCheckConditionPConstraint(GTPatternBodyToPSystem<StubHandle, ?> pGraph, GTASMBuildable<StubHandle, ?> gtBuildable, Term topTerm) throws RetePatternBuildException {
        super(pGraph.pSystem, GTASMCheckConditionPConstraint.extractAffectedVariables(pGraph, topTerm));
        this.pGraph = pGraph;
        this.topTerm = topTerm;
        this.gtBuildable = gtBuildable;
    }

    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        HashMap<String, Integer> variableIndices = new HashMap<String, Integer>();
        HashMap<String, String> variableEquivalence = new HashMap<String, String>();
        Set<String> variableNames = GTASMCheckConditionPConstraint.extractAffectedVariableNames(this.pGraph, this.topTerm);
        for (String name : variableNames) {
            PVariable pNode = this.pGraph.getPNode(name);
            variableEquivalence.put(name, pNode.getName());
            variableIndices.put(pNode.getName(), (Integer)stub.getVariablesIndex().get(pNode));
        }
        return this.gtBuildable.buildGTASMTermChecker(this.topTerm, variableIndices, variableEquivalence, null, stub);
    }

    protected String toStringRest() {
        return String.valueOf(new FlatTuple(new ArrayList(this.getAffectedVariables()).toArray()).toString()) + "|=" + this.topTerm.toString();
    }

    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
    }

    private static <StubHandle> Set<PVariable> extractAffectedVariables(GTPatternBodyToPSystem<StubHandle, ?> pGraph, Term topTerm) throws RetePatternBuildException {
        HashSet<PVariable> affected = new HashSet<PVariable>();
        Set<String> variableNames = GTASMCheckConditionPConstraint.extractAffectedVariableNames(pGraph, topTerm);
        for (String name : variableNames) {
            PVariable termNode = pGraph.getPNode(name);
            affected.add(termNode);
        }
        return affected;
    }

    private static <StubHandle> Set<String> extractAffectedVariableNames(GTPatternBodyToPSystem<StubHandle, ?> pGraph, Term topTerm) throws RetePatternBuildException {
        HashSet<String> affected = new HashSet<String>();
        LinkedList<Term> termQueue = new LinkedList<Term>();
        termQueue.add(topTerm);
        while (termQueue.size() > 0) {
            Term term = (Term)termQueue.removeFirst();
            if (term instanceof VariableReference) {
                VariableReference termVar = (VariableReference)term;
                affected.add(termVar.getVariable().getName());
                continue;
            }
            if (term instanceof FunctionInvocation) {
                FunctionInvocation fi = (FunctionInvocation)term;
                for (Term paramTerm : fi.getActualParameters()) {
                    termQueue.addFirst(paramTerm);
                }
                continue;
            }
            if (term instanceof ModelElementQuery) {
                ModelElementQuery meq = (ModelElementQuery)term;
                termQueue.addFirst(meq.getArgument());
                continue;
            }
            if (!(term instanceof GTPatternCall)) continue;
            GTPatternCall pc = (GTPatternCall)term;
            String[] errorData = new String[]{pc.getCalledPattern().getFqn(), pGraph.gtPattern.getFqn()};
            String message = "Offending call to pattern {1} in enclosing pattern {2}. The incremental pattern matcher does not support GT Pattern calls in checks and expressions embedded into GT Patterns; please use a 'find' clause directly in the pattern body.";
            throw new RetePatternBuildException(message, errorData, (Object)pGraph.gtPattern);
        }
        return affected;
    }
}

