/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.LayoutHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.Equality;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.Inequality;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.Containment;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.Generalization;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.Instantiation;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.TypeBinary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.TypeTernary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.basicenumerables.TypeUnary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.GTASMCheckConditionPConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ContainmentMode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTMatchCounter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.NonInjectivityConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableAssignment;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.SupertypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.TypeOf;

class GTPatternBodyToPSystem<StubHandle, Collector> {
    protected GTPattern gtPattern;
    protected GTPatternBody body;
    protected SimpleReteBuilder<StubHandle, Collector> builder;
    protected GTASMBuildable<StubHandle, Collector> buildable;
    protected Entity graphEntity;
    protected PSystem<GTPattern, StubHandle, Collector> pSystem;
    protected Map<PVariable, Object> constantValues = new HashMap<PVariable, Object>();
    protected Map<PVariable, Set<ModelElement>> sourceEditModelElements = new HashMap<PVariable, Set<ModelElement>>();

    public GTPatternBodyToPSystem(GTPattern gtPattern, GTPatternBody body, SimpleReteBuilder<StubHandle, Collector> builder, GTASMBuildable<StubHandle, Collector> buildable) {
        this.gtPattern = gtPattern;
        this.body = body;
        this.builder = builder;
        this.buildable = buildable;
        this.graphEntity = body.getPatternGraph();
    }

    public PSystem<GTPattern, StubHandle, Collector> toPSystem() throws RetePatternBuildException {
        if (this.pSystem == null) {
            this.pSystem = new PSystem(this.builder.getContext(), this.buildable, (Object)this.gtPattern);
            this.preProcessAssignments();
            this.preProcessPVariables();
            this.gatherInequalityAssertions();
            this.gatherContainmentConstraints();
            this.gatherRelationsAndContainments();
            this.gatherRelationships();
            this.gatherPositivePatternCalls();
            this.gatherCheckExpressions();
            this.gatherNegativePatternCalls();
        }
        return this.pSystem;
    }

    public PVariable[] symbolicParameterArray() throws RetePatternBuildException {
        this.toPSystem();
        EList symParameters = this.gtPattern.getSymParameters();
        int arity = symParameters.size();
        PVariable[] result = new PVariable[arity];
        int i = 0;
        while (i < arity) {
            result[i] = this.getPNode((Variable)symParameters.get(i));
            ++i;
        }
        return result;
    }

    protected PVariable getPNode(String name) {
        return this.pSystem.getOrCreateVariableByName(name);
    }

    protected PVariable getPNode(Variable variable) {
        return this.getPNode(variable.getName());
    }

    protected PVariable getPNode(ModelElement element) {
        return this.getPNode(element.getName());
    }

    protected Entity getGraphEntity() {
        return this.graphEntity;
    }

    protected boolean traceVariableToEditModel(PVariable pVar, ModelElement editModelElement) {
        Set<ModelElement> sources = this.sourceEditModelElements.get(pVar);
        if (sources == null) {
            sources = new HashSet<ModelElement>();
            this.sourceEditModelElements.put(pVar, sources);
        }
        return sources.add(editModelElement);
    }

    protected Set<ModelElement> traceBackVariable(PVariable pVar) {
        Set<ModelElement> sources = this.sourceEditModelElements.get(pVar);
        if (sources == null) {
            return Collections.emptySet();
        }
        return sources;
    }

    protected void preProcessAssignments() {
        for (Object o : this.body.getVariableAssignments()) {
            PatternVariableAssignment assignment = (PatternVariableAssignment)o;
            String lName = assignment.getLeftValue().getVariable().getName();
            String rName = assignment.getRightValue().getVariable().getName();
            new Equality(this.pSystem, this.getPNode(lName), this.getPNode(rName));
        }
        LayoutHelper.unifyVariablesAlongEqualities(this.pSystem);
    }

    protected void preProcessPVariables() throws RetePatternBuildException {
        for (PatternVariable o : this.gtPattern.getSymParameters()) {
            this.preProcessPVariableVariables(o);
            new ExportedParameter(this.pSystem, this.getPNode((Variable)o), o.getName());
        }
        for (PatternVariable o : this.body.getLocalVariables()) {
            this.preProcessPVariableVariables(o);
        }
        this.preProcessPVariableEntities((Collection<Entity>)this.graphEntity.getComponents());
    }

    protected void preProcessPVariableVariables(PatternVariable variable) {
        this.getPNode((Variable)variable);
    }

    protected void preProcessPVariableEntities(Collection<Entity> entities) throws RetePatternBuildException {
        for (Entity entity : entities) {
            String name = entity.getName();
            PVariable pNode = this.getPNode(name);
            this.traceVariableToEditModel(pNode, (ModelElement)entity);
            this.preProcessPVariableEntities((Collection<Entity>)entity.getComponents());
        }
    }

    protected PVariable newConstant(Constant constant) throws RetePatternBuildException {
        Object value = constant.getKind().getValue() == 5 ? this.builder.context.resolveConstant(constant.getValue()) : constant.getValue();
        return this.pSystem.newConstantVariable(value);
    }

    protected PVariable newConstant(ElementReference reference) throws RetePatternBuildException {
        String fqn = ((Constant)reference.getArgument()).getValue();
        return this.newConstant(fqn);
    }

    protected PVariable newConstant(String fqn) throws RetePatternBuildException {
        Object value = this.builder.context.resolveConstant(fqn);
        return this.pSystem.newConstantVariable(value);
    }

    protected void gatherInequalityAssertions() throws RetePatternBuildException {
        if (this.gtPattern.isDistinctMatching()) {
            HashMap<PVariable, HashSet<PVariable>> permittableEquality = new HashMap<PVariable, HashSet<PVariable>>();
            Set uniqueVariables = this.pSystem.getUniqueVariables();
            for (PVariable pNode : uniqueVariables) {
                permittableEquality.put(pNode, new HashSet<PVariable>(Collections.singleton(pNode)));
            }
            for (GTPatternCall call : this.body.getCalledPatterns()) {
                GTMatchCounter matchCounter = call.getMatchCounter();
                if (matchCounter == null && call.getCalledPattern().isDistinctMatching()) {
                    Object pNode;
                    PVariable[] parameters = this.extractPatternCallParameterArray(call);
                    HashMap<PatternVariable, PVariable> symParamToPVariable = new HashMap<PatternVariable, PVariable>();
                    int k = 0;
                    for (PatternVariable variable : call.getCalledPattern().getSymParameters()) {
                        symParamToPVariable.put(variable, parameters[k++]);
                    }
                    HashMap<PVariable, HashSet<PVariable>> localPermittableEquality = new HashMap<PVariable, HashSet<PVariable>>();
                    Object object = parameters;
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        pNode = object[n2];
                        localPermittableEquality.put((PVariable)pNode, new HashSet<PVariable>(Arrays.asList(parameters)));
                        ++n2;
                    }
                    for (GTPatternBody body : call.getCalledPattern().getPatternBodies()) {
                        for (PatternVariableAssignment varAss : body.getVariableAssignments()) {
                            PVariable left = (PVariable)symParamToPVariable.get(varAss.getLeftValue().getVariable());
                            PVariable right = (PVariable)symParamToPVariable.get(varAss.getRightValue().getVariable());
                            if (left == null || right == null) continue;
                            ((Set)localPermittableEquality.get(left)).remove(right);
                            ((Set)localPermittableEquality.get(right)).remove(left);
                        }
                    }
                    object = parameters;
                    n = parameters.length;
                    n2 = 0;
                    while (n2 < n) {
                        pNode = object[n2];
                        ((Set)permittableEquality.get(pNode)).addAll((Collection)localPermittableEquality.get(pNode));
                        ++n2;
                    }
                }
                if (matchCounter == null) continue;
                PVariable resultVar = this.getPNode(matchCounter.getVariableReference().getVariable());
                ((Set)permittableEquality.get(resultVar)).addAll(uniqueVariables);
                for (PVariable pNode : uniqueVariables) {
                    ((Set)permittableEquality.get(pNode)).add(resultVar);
                }
            }
            for (PVariable pNode1 : uniqueVariables) {
                if (pNode1.isVirtual()) continue;
                for (PVariable pNode2 : uniqueVariables) {
                    if (pNode2.isVirtual() || ((Set)permittableEquality.get(pNode1)).contains(pNode2) || pNode1.getName().compareTo(pNode2.getName()) >= 0) continue;
                    new Inequality(this.pSystem, pNode1, pNode2, true);
                }
            }
        }
        for (Object o : this.body.getNonInjectivityConstraints()) {
            NonInjectivityConstraint nic = (NonInjectivityConstraint)o;
            PVariable left = this.getPNode(nic.getLeftValue().getVariable());
            PVariable right = this.getPNode(nic.getRightValue().getVariable());
            new Inequality(this.pSystem, left, right);
        }
    }

    protected void gatherRelationsAndContainments() {
        LinkedList<PVariable> nodeQueue = new LinkedList<PVariable>(this.pSystem.getUniqueVariables());
        for (Object rel : this.body.getDanglingRelations()) {
            this.gatherRelation((Relation)rel, nodeQueue);
        }
        while (!nodeQueue.isEmpty()) {
            PVariable pNode = (PVariable)nodeQueue.removeFirst();
            for (ModelElement source : this.traceBackVariable(pNode)) {
                Relation rel;
                for (Object o : source.getRelationsFrom()) {
                    rel = (Relation)o;
                    this.gatherRelation(rel, nodeQueue);
                }
                for (Object o : source.getRelationsTo()) {
                    rel = (Relation)o;
                    this.gatherRelation(rel, nodeQueue);
                }
                if (!(source instanceof Entity)) continue;
                Entity entity = (Entity)source;
                for (Object o : entity.getComponents()) {
                    new Containment(this.pSystem, pNode, this.getPNode((ModelElement)((Entity)o)), false);
                }
            }
        }
    }

    protected void gatherRelation(Relation rel, Queue<PVariable> nodeQueue) {
        PVariable pNode = this.getPNode((ModelElement)rel);
        if (this.traceVariableToEditModel(pNode, (ModelElement)rel)) {
            nodeQueue.add(pNode);
        }
    }

    protected void gatherRelationships() throws RetePatternBuildException {
        LinkedHashSet<Relationship> relationships = new LinkedHashSet<Relationship>((Collection<Relationship>)this.body.getDanglingRelationships());
        try {
            for (PVariable pNode : this.pSystem.getUniqueVariables()) {
                for (ModelElement source : this.traceBackVariable(pNode)) {
                    ArrayList<String> typeNames = new ArrayList<String>();
                    for (Object o : source.getSubRelationships()) {
                        relationships.add((Relationship)o);
                    }
                    for (Object o : source.getSuperRelationships()) {
                        Relationship rship = (Relationship)o;
                        if (rship instanceof TypeOf && rship.getSupplier() != null && rship.getSupplier().getRealElement() != null && !rship.getSupplier().getRealElement().equals("")) {
                            String supplierName = rship.getSupplier().getRealElement();
                            typeNames.add(supplierName);
                            continue;
                        }
                        relationships.add(rship);
                    }
                    if (typeNames.isEmpty()) {
                        typeNames.add(null);
                    }
                    this.expressTypesOnPNode(pNode, source, typeNames);
                }
            }
            for (Relationship rship : relationships) {
                this.gatherRelationship(rship);
            }
        }
        catch (RetePatternBuildException e) {
            e.setPatternDescription((Object)this.gtPattern);
            throw e;
        }
    }

    protected void expressTypesOnPNode(PVariable pNode, ModelElement source, List<String> typeNames) throws RetePatternBuildException {
        if (source instanceof Relation) {
            Relation relation = (Relation)source;
            PVariable fromPNode = this.getPNode(relation.getFromStr());
            PVariable toPNode = this.getPNode(relation.getToStr());
            if (this.builder.context.edgeInterpretation() == IPatternMatcherContext.EdgeInterpretation.TERNARY) {
                for (String supplierName : typeNames) {
                    Object typeObject = supplierName == null ? null : this.builder.context.retrieveTernaryEdgeType(supplierName);
                    new TypeTernary(this.pSystem, this.builder.getContext(), pNode, fromPNode, toPNode, typeObject);
                }
            } else {
                for (String supplierName : typeNames) {
                    Object typeObject = supplierName == null ? null : this.builder.context.retrieveBinaryEdgeType(supplierName);
                    new TypeBinary(this.pSystem, this.builder.getContext(), fromPNode, toPNode, typeObject);
                }
            }
        } else {
            for (String supplierName : typeNames) {
                Object typeObject = supplierName == null ? null : this.builder.context.retrieveUnaryType(supplierName);
                new TypeUnary(this.pSystem, pNode, typeObject);
            }
        }
    }

    protected void gatherRelationship(Relationship rship) throws RetePatternBuildException {
        String supplierName;
        PVariable supplierNode;
        String clientName = rship.getClientStr();
        PVariable clientNode = this.getPNode(clientName);
        if (clientNode == null) {
            clientNode = this.newConstant(clientName);
        }
        if ((supplierNode = this.getPNode(supplierName = rship.getSupplierStr())) == null) {
            supplierNode = this.newConstant(supplierName);
        }
        if (rship instanceof TypeOf) {
            new Instantiation(this.pSystem, supplierNode, clientNode, true);
        } else if (rship instanceof SupertypeOf) {
            new Generalization(this.pSystem, supplierNode, clientNode, true);
        } else {
            String[] args = new String[]{rship.eClass().getName(), supplierName, clientName, this.gtPattern.getFqn()};
            String msg = "Unsupported VPM Relationship type: {1} encountered between {2} and {3} in pattern {4}";
            throw new RetePatternBuildException(msg, args, (Object)this.gtPattern);
        }
    }

    protected void gatherContainmentConstraints() throws RetePatternBuildException {
        for (Object o : this.body.getContainmentConstraints()) {
            PVariable parent;
            ContainmentConstraint cc = (ContainmentConstraint)o;
            PVariable child = this.getPNode(cc.getVariable());
            boolean transitive = cc.getMode().equals((Object)ContainmentMode.BELOW_LITERAL);
            if (cc.getParent() instanceof VariableReference) {
                VariableReference parentVar = (VariableReference)cc.getParent();
                parent = this.getPNode(parentVar.getVariable());
            } else if (cc.getParent() instanceof Constant) {
                parent = this.newConstant((Constant)cc.getParent());
            } else if (cc.getParent() instanceof ElementReference) {
                parent = this.newConstant((ElementReference)cc.getParent());
            } else {
                throw new RetePatternBuildException("Incremental matcher incompatible with containment parent {1} of {2}.", new String[]{cc.getParent().toString(), child.toString()}, (Object)this.gtPattern);
            }
            new Containment(this.pSystem, parent, child, transitive);
        }
    }

    protected void gatherPositivePatternCalls() throws RetePatternBuildException {
        for (Object o : this.body.getCalledPatterns()) {
            GTPatternCall call = (GTPatternCall)o;
            GTPattern calledPattern = call.getCalledPattern();
            Tuple parameters = this.extractPatternCallParameterTuple(call);
            GTMatchCounter matchCounter = call.getMatchCounter();
            if (matchCounter == null) {
                new PositivePatternCall(this.pSystem, parameters, (Object)calledPattern);
                continue;
            }
            PVariable resultVariable = this.getPNode(matchCounter.getVariableReference().getVariable());
            new PatternMatchCounter(this.pSystem, parameters, (Object)calledPattern, resultVariable);
        }
    }

    protected void gatherNegativePatternCalls() throws RetePatternBuildException {
        for (Object o : this.body.getNegativePatterns()) {
            GTPatternCall call = (GTPatternCall)o;
            GTPattern calledPattern = call.getCalledPattern();
            Tuple parameters = this.extractPatternCallParameterTuple(call);
            new NegativePatternCall(this.pSystem, parameters, (Object)calledPattern);
        }
    }

    protected Tuple extractPatternCallParameterTuple(GTPatternCall call) throws RetePatternBuildException {
        Object[] nodes = this.extractPatternCallParameterArray(call);
        FlatTuple parameters = new FlatTuple(nodes);
        return parameters;
    }

    protected PVariable[] extractPatternCallParameterArray(GTPatternCall call) throws RetePatternBuildException {
        int paramNum = call.getActualParameters().size();
        PVariable[] nodes = new PVariable[paramNum];
        int i = 0;
        while (i < paramNum) {
            PVariable paramNode;
            Object actualParam = call.getActualParameters().get(i);
            if (actualParam instanceof VariableReference) {
                VariableReference paramVar = (VariableReference)actualParam;
                nodes[i] = paramNode = this.getPNode(paramVar.getVariable());
            } else if (actualParam instanceof Constant) {
                Constant constant = (Constant)actualParam;
                nodes[i] = paramNode = this.newConstant(constant);
            } else if (actualParam instanceof ElementReference) {
                ElementReference reference = (ElementReference)actualParam;
                nodes[i] = paramNode = this.newConstant(reference);
            } else {
                throw new RetePatternBuildException("Incremental matcher incompatible with parameter {3} of the pattern call of {2}: unsupported expression term {1}.", new String[]{actualParam.toString(), call.getCalledPattern().getFqn(), Integer.toString(i)}, (Object)this.gtPattern);
            }
            ++i;
        }
        return nodes;
    }

    protected void gatherCheckExpressions() throws RetePatternBuildException {
        for (Object o : this.body.getCheckExpressions()) {
            Term topTerm = (Term)o;
            new GTASMCheckConditionPConstraint<StubHandle>(this, this.buildable, topTerm);
        }
    }
}

