/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.helpers.BuildHelper;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.util.Options;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.GTPatternBodyToPSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.legacy.BodyScaffold;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;

public class PatternScaffold<StubHandle, Collector> {
    protected SimpleReteBuilder<StubHandle, Collector> baseBuilder;
    protected GTASMBuildable<StubHandle, Collector> baseBuildable;
    protected GTPattern gtPattern;
    protected Collector prodNode;

    public PatternScaffold(SimpleReteBuilder<StubHandle, Collector> builder, GTPattern gtPattern, Collector production) {
        this.baseBuilder = builder;
        this.baseBuildable = builder.baseBuildable;
        this.gtPattern = gtPattern;
        this.prodNode = production;
    }

    public Collector run() throws RetePatternBuildException {
        this.baseBuilder.context.logDebug("SimpleReteBuilder starts construction of: " + this.gtPattern.getName());
        Collector collector = this.prodNode;
        for (GTPatternBody body : this.gtPattern.getPatternBodies()) {
            GTASMBuildable<StubHandle, Collector> currentBuildable = this.baseBuildable.getNextContainer().putOnTab(this.gtPattern);
            if (Options.builderMethod == Options.BuilderMethod.LEGACY) {
                new BodyScaffold<StubHandle, Collector>(this.baseBuilder, currentBuildable, this, body, collector).run();
                continue;
            }
            GTPatternBodyToPSystem<StubHandle, Collector> converter = new GTPatternBodyToPSystem<StubHandle, Collector>(this.gtPattern, body, this.baseBuilder, currentBuildable);
            Stub bodyFinal = Options.builderMethod.layoutStrategy().layout(converter.toPSystem());
            BuildHelper.projectIntoCollector(currentBuildable, (Stub)bodyFinal, collector, (PVariable[])converter.symbolicParameterArray());
        }
        return this.prodNode;
    }

    public GTPattern getGtPattern() {
        return this.gtPattern;
    }
}

