/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.trigger.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.content.IFrameworkContentProviderExtension;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.content.ITreeParent;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.gtasm.trigger.Activator;
import org.eclipse.viatra2.gtasm.trigger.engine.ITriggerSetChangedListener;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerEngineManager;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerExecutionEngine;
import org.eclipse.viatra2.gtasm.trigger.model.Trigger;
import org.eclipse.viatra2.gtasm.trigger.view.DeleteTriggerAction;
import org.eclipse.viatra2.gtasm.trigger.view.StartTriggerAction;
import org.eclipse.viatra2.gtasm.trigger.view.StopTriggerAction;
import org.eclipse.viatra2.gtasm.trigger.view.SwitchExecutionModeAction;
import org.eclipse.viatra2.gtasm.trigger.view.TriggerPropertySource;

public class FrameworkViewExtension
implements IFrameworkContentProviderExtension,
ITreeParent,
ITriggerSetChangedListener {
    private DeleteTriggerAction deleteAction;
    private StartTriggerAction startAction;
    private StopTriggerAction stopAction;
    private SwitchExecutionModeAction switchAction;
    private Vector<IAction> actions;
    private Vector<IAction> sActions;
    private FrameworkTreeView viewer;
    private IFramework fw;
    private TriggerExecutionEngine tee;
    private FrameworkContainer cont;
    private Map<Object, ITreeObject> triggers = new HashMap<Object, ITreeObject>();
    private static Image trigger_loaded = Activator.getImageDescriptor("icons/trigger_loaded.png").createImage();
    private static Image trigger_running = Activator.getImageDescriptor("icons/trigger_running.png").createImage();
    private static Image trigger_stopped = Activator.getImageDescriptor("icons/trigger_stopped.png").createImage();

    public FrameworkViewExtension() {
        this.actions = new Vector();
        this.sActions = new Vector();
    }

    public void init(FrameworkTreeView fv, IFramework f, FrameworkContainer c) {
        this.viewer = fv;
        this.fw = f;
        this.cont = c;
        this.tee = TriggerEngineManager.getInstance().getTriggerEngine(this.fw);
        this.deleteAction = new DeleteTriggerAction(fv);
        this.startAction = new StartTriggerAction(fv);
        this.stopAction = new StopTriggerAction(fv);
        this.switchAction = new SwitchExecutionModeAction(fv, this.fw, this.tee);
        this.actions.add((IAction)this.deleteAction);
        this.actions.add((IAction)this.startAction);
        this.actions.add((IAction)this.stopAction);
        this.sActions.add((IAction)this.switchAction);
        this.initTriggers();
        this.tee.addTriggerSetListener(this);
    }

    private void initTriggers() {
        for (Trigger _m : this.tee.getTriggers()) {
            if (!(_m instanceof Trigger)) continue;
            this.triggers.put(_m, new TriggerDummy(_m));
        }
    }

    public Collection<IAction> getActions() {
        return this.sActions;
    }

    public Collection<IContributionItem> getContributionItems() {
        return null;
    }

    public ITreeObject getTopLevelEntry() {
        return this;
    }

    public void dispose() {
        this.tee.removeTriggerSetListener(this);
    }

    public Set<ITreeObject> getChildren() {
        return new HashSet<ITreeObject>(this.triggers.values());
    }

    public boolean hasChildren() {
        return !this.triggers.isEmpty();
    }

    public FrameworkContainer getFrameworkContainer() {
        return this.cont;
    }

    public Image getLabelImage() {
        return null;
    }

    public String getLabelText() {
        String s = this.tee.isSerialExecutionMode() ? "Triggers (serial execution mode)" : "Triggers (parallel execution mode)";
        return s;
    }

    public ITreeParent getParent() {
        return this.cont;
    }

    public IPropertySource2 getPropertySource() {
        return null;
    }

    @Override
    public void triggerAdded(Object trigger) {
        if (trigger instanceof Trigger) {
            this.triggers.put(trigger, new TriggerDummy((Trigger)trigger));
        }
        this.viewer.refreshViewer((Object)this);
    }

    @Override
    public void triggerRemoved(Object trigger) {
        if (trigger instanceof Trigger) {
            this.triggers.remove(trigger);
        }
        this.viewer.refreshViewer((Object)this);
    }

    @Override
    public void triggerRefreshed(Object trigger) {
        if (trigger instanceof Trigger) {
            this.triggers.remove(trigger);
            this.triggers.put(trigger, new TriggerDummy((Trigger)trigger));
        }
        this.viewer.refreshViewer((Object)this);
    }

    public IAction getDoubleClickAction() {
        return null;
    }

    public class TriggerDummy
    implements ITreeObject {
        private Trigger trigger;

        public TriggerDummy(Trigger t) {
            this.trigger = t;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public FrameworkContainer getFrameworkContainer() {
            return FrameworkViewExtension.this.cont;
        }

        public Image getLabelImage() {
            if (!this.trigger.isReteEngineSet()) {
                return trigger_loaded;
            }
            if (this.trigger.isRunning()) {
                return trigger_running;
            }
            return trigger_stopped;
        }

        public String getLabelText() {
            return this.trigger.getName();
        }

        public ITreeParent getParent() {
            return FrameworkViewExtension.this;
        }

        public IPropertySource2 getPropertySource() {
            TriggerPropertySource tps = new TriggerPropertySource(this.trigger);
            return tps;
        }

        public Collection<IContributionItem> getContributionItems() {
            return null;
        }

        public Collection<IAction> getActions() {
            return FrameworkViewExtension.this.actions;
        }

        public IAction getDoubleClickAction() {
            return null;
        }
    }
}

