/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content.transformation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrossReferenceManager {
    private Map<String, Set<String>> unresolved = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> callgraph_forward = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> callgraph_backward = new HashMap<String, Set<String>>();

    public boolean hasUnresolvedReferences(String machineID) {
        return this.unresolved.keySet().contains(machineID);
    }

    public void addMachineReference(String callerID, String referredID) {
        this.addToGraph(callerID, referredID, this.callgraph_forward);
        this.addToGraph(referredID, callerID, this.callgraph_backward);
    }

    private void addToGraph(String key, String value, Map<String, Set<String>> map) {
        Set<String> target = map.get(key);
        if (target == null) {
            target = new HashSet<String>();
        }
        target.add(value);
        map.put(key, target);
    }

    public void deleteMachineReferences(String callerID) {
        this.callgraph_forward.put(callerID, new HashSet());
    }

    public void checkUnresolvedReference(String removedMachineID) {
        Set<String> referencing_machines = this.callgraph_backward.get(removedMachineID);
        if (referencing_machines != null) {
            for (String ref_m : referencing_machines) {
                Set<String> _t = this.unresolved.get(ref_m);
                if (_t == null) {
                    _t = new HashSet<String>();
                }
                _t.add(removedMachineID);
                this.unresolved.put(ref_m, _t);
            }
        }
    }

    public void checkResolvedReference(String machineAddedID) {
        Set<String> referencing_machines = this.callgraph_backward.get(machineAddedID);
        if (referencing_machines != null) {
            for (String ref_m : referencing_machines) {
                Set<String> unresolved_targets = this.unresolved.get(ref_m);
                if (unresolved_targets != null) {
                    unresolved_targets.remove(machineAddedID);
                    this.unresolved.put(ref_m, unresolved_targets);
                }
                if (unresolved_targets != null && unresolved_targets.size() != 0) continue;
                this.unresolved.remove(ref_m);
            }
        }
    }
}

