/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content.transformation;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.framework.FrameworkException;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.TransformationContent;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;

public class DeleteModelAction
extends AbstractFrameworkGUIAction {
    public DeleteModelAction(FrameworkTreeView part) {
        this.setupInternals(part);
        this.setText("Drop");
        this.setToolTipText("Drops the machine model from the framework");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void run() {
        this.refreshSelection();
        try {
            Object[] objectArray = ((IStructuredSelection)this.iFT.getSelection()).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object c = objectArray[n2];
                if (c instanceof TransformationContent.MachineDummy) {
                    this.iViatraFramework.removeMachine(((TransformationContent.MachineDummy)c).machine.getFqn());
                }
                ++n2;
            }
        }
        catch (FrameworkException e) {
            this.iFT.showMessage("Framework error: " + e.getMessage());
        }
    }
}

