/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content.transformation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IMachineSetChangedListener;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.actions.extend.ContributedActionContainer;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.content.IFrameworkContentProviderExtension;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.content.ITreeParent;
import org.eclipse.viatra2.frameworkgui.content.transformation.CrossReferenceManager;
import org.eclipse.viatra2.frameworkgui.content.transformation.DeleteModelAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.MachinePropertySource;
import org.eclipse.viatra2.frameworkgui.content.transformation.RunModelAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.SaveModelAction;
import org.eclipse.viatra2.frameworkgui.content.transformation.SaveTransformationAction;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.GTASMElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.CallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.GTRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ASMFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.lpgparser.modelbuilder.VTCLModelResolver;

public class TransformationContent
implements IFrameworkContentProviderExtension,
IMachineSetChangedListener,
ITreeParent {
    private RunModelAction runAction;
    private DeleteModelAction deleteAction;
    private SaveModelAction saveAction;
    private SaveTransformationAction saveTransformationAction;
    private Vector<IAction> actions;
    private CrossReferenceManager xrefman;
    private FrameworkTreeView viewer;
    private IFramework fw;
    private FrameworkContainer cont;
    private Map<Object, ITreeObject> machines = new HashMap<Object, ITreeObject>();
    protected static Image machine_image = FrameworkGUIPlugin.getImageDescriptor("icons/machine_transparent.png").createImage();
    private Map<EObject, Collection<EStructuralFeature.Setting>> brokenRefs;

    @Override
    public Collection<IAction> getActions() {
        ArrayList<IAction> r = new ArrayList<IAction>();
        r.add((IAction)this.saveTransformationAction);
        return r;
    }

    @Override
    public Collection<IContributionItem> getContributionItems() {
        return null;
    }

    @Override
    public ITreeObject getTopLevelEntry() {
        return this;
    }

    private void processContributedActions(FrameworkTreeView ftv) {
        for (ContributedActionContainer c : FrameworkGUIPlugin.getDefault().getContributedActions()) {
            if (!c.enablesFor.equals(Machine.class)) continue;
            c.action.setupInternals(ftv);
            this.actions.add((IAction)c.action);
        }
    }

    @Override
    public void init(FrameworkTreeView fv, IFramework f, FrameworkContainer c) {
        this.viewer = fv;
        this.fw = f;
        this.cont = c;
        this.runAction = new RunModelAction(fv);
        this.deleteAction = new DeleteModelAction(fv);
        this.saveAction = new SaveModelAction(fv);
        this.saveTransformationAction = new SaveTransformationAction(fv);
        this.xrefman = new CrossReferenceManager();
        this.processContributedActions(fv);
        this.actions.add((IAction)this.runAction);
        this.actions.add((IAction)this.deleteAction);
        this.actions.add((IAction)this.saveAction);
        this.initMachines();
        f.addMachineSetListener((IMachineSetChangedListener)this);
        this.brokenRefs = new HashMap<EObject, Collection<EStructuralFeature.Setting>>();
    }

    public TransformationContent() {
        this.actions = new Vector();
    }

    @Override
    public void dispose() {
        this.fw.removeMachineSetListener((IMachineSetChangedListener)this);
    }

    @Override
    public Set<ITreeObject> getChildren() {
        return new HashSet<ITreeObject>(this.machines.values());
    }

    @Override
    public boolean hasChildren() {
        return !this.machines.isEmpty();
    }

    @Override
    public FrameworkContainer getFrameworkContainer() {
        return this.cont;
    }

    @Override
    public Image getLabelImage() {
        return null;
    }

    @Override
    public String getLabelText() {
        return "Program models";
    }

    @Override
    public ITreeParent getParent() {
        return this.cont;
    }

    @Override
    public IPropertySource2 getPropertySource() {
        return null;
    }

    private void initMachines() {
        for (Object _m : this.fw.getMachines()) {
            if (!(_m instanceof Machine)) continue;
            this.machines.put(_m, new MachineDummy((Machine)_m));
        }
    }

    public void machineAdded(Object machine) {
        if (machine instanceof Machine) {
            this.resolveBrokenLinks((Machine)machine);
            this.machines.put(machine, new MachineDummy((Machine)machine));
            this.xrefman.checkResolvedReference(((Machine)machine).getFqn());
        }
        this.viewer.refreshViewer(this);
    }

    public void machineRemoved(Object machine) {
        if (machine instanceof Machine) {
            this.recordBrokenLinks((Machine)machine);
            this.machines.remove(machine);
            this.xrefman.checkUnresolvedReference(((Machine)machine).getFqn());
        }
        this.viewer.refreshViewer(this);
    }

    @Override
    public IAction getDoubleClickAction() {
        return null;
    }

    protected void recordBrokenLinks(Machine removedMachine) {
        ArrayList<Object> defsToResolve = new ArrayList<Object>();
        ArrayList<Machine> machinesToSearch = new ArrayList<Machine>();
        int i = 0;
        while (i < removedMachine.getAsmFunctionDefinitions().size()) {
            ASMFunction asmFun = (ASMFunction)removedMachine.getAsmFunctionDefinitions().get(i);
            defsToResolve.add(asmFun);
            ++i;
        }
        i = 0;
        while (i < removedMachine.getAsmRuleDefinitions().size()) {
            Rule asmRule = (Rule)removedMachine.getAsmRuleDefinitions().get(i);
            defsToResolve.add(asmRule);
            ++i;
        }
        i = 0;
        while (i < removedMachine.getGtPatternDefinitions().size()) {
            GTPattern gtPatt = (GTPattern)removedMachine.getGtPatternDefinitions().get(i);
            defsToResolve.add(gtPatt);
            ++i;
        }
        i = 0;
        while (i < removedMachine.getGtRuleDefinitions().size()) {
            GTRule gtRule = (GTRule)removedMachine.getGtRuleDefinitions().get(i);
            defsToResolve.add(gtRule);
            ++i;
        }
        for (Object obj : this.fw.getMachines()) {
            Machine machine = (Machine)obj;
            if (machine == removedMachine) continue;
            machinesToSearch.add(machine);
        }
        if (!machinesToSearch.isEmpty() && !defsToResolve.isEmpty()) {
            this.brokenRefs.putAll(EcoreUtil.UsageCrossReferencer.findAll(defsToResolve, machinesToSearch));
        }
        this.removeLinksFromRemovedMachine(removedMachine);
    }

    protected void removeLinksFromRemovedMachine(Machine removedMachine) {
        ArrayList<EStructuralFeature.Setting> toRemove = new ArrayList<EStructuralFeature.Setting>();
        if (this.brokenRefs != null) {
            toRemove.clear();
            for (Collection<EStructuralFeature.Setting> settings : this.brokenRefs.values()) {
                for (EStructuralFeature.Setting setting : settings) {
                    GTASMElement element = (GTASMElement)setting.getEObject();
                    if (EcoreUtil.isAncestor((EObject)removedMachine, (EObject)element)) {
                        toRemove.add(setting);
                    }
                    setting.unset();
                }
                if (toRemove.isEmpty()) continue;
                settings.removeAll(toRemove);
            }
            ArrayList<EObject> brokenRefsToRemove = new ArrayList<EObject>();
            for (EObject nextKey : this.brokenRefs.keySet()) {
                if (!this.brokenRefs.get(nextKey).isEmpty()) continue;
                brokenRefsToRemove.add(nextKey);
            }
            for (EObject nextObject : brokenRefsToRemove) {
                this.brokenRefs.remove(nextObject);
            }
        }
    }

    protected void resolveBrokenLinks(Machine addedMachine) {
        ArrayList<EStructuralFeature.Setting> toRemove = new ArrayList<EStructuralFeature.Setting>();
        if (this.brokenRefs != null) {
            for (Collection<EStructuralFeature.Setting> settings : this.brokenRefs.values()) {
                toRemove.clear();
                for (EStructuralFeature.Setting setting : settings) {
                    GTASMElement result = this.resolveGTASMElement(setting);
                    if (result == null) continue;
                    toRemove.add(setting);
                }
                if (toRemove.isEmpty()) continue;
                settings.removeAll(toRemove);
            }
            ArrayList<EObject> brokenRefsToRemove = new ArrayList<EObject>();
            for (EObject nextKey : this.brokenRefs.keySet()) {
                if (!this.brokenRefs.get(nextKey).isEmpty()) continue;
                brokenRefsToRemove.add(nextKey);
            }
            for (EObject nextObject : brokenRefsToRemove) {
                this.brokenRefs.remove(nextObject);
            }
        }
    }

    protected GTASMElement resolveGTASMElement(EStructuralFeature.Setting setting) {
        EObject refObject = setting.getEObject();
        VTCLModelResolver fModelResolver = new VTCLModelResolver();
        if (refObject instanceof CallRule) {
            CallRule asmRuleInvoc = (CallRule)refObject;
            return fModelResolver.reportAsmRuleInvocResolutionError(asmRuleInvoc, null, this.fw);
        }
        if (refObject instanceof GTPatternCall) {
            GTPatternCall pattCall = (GTPatternCall)refObject;
            return fModelResolver.reportGtPatternCallResolutionError(pattCall, null, this.fw);
        }
        if (refObject instanceof GTRuleInvocation) {
            GTRuleInvocation gtInvoc = (GTRuleInvocation)refObject;
            return fModelResolver.reportGtRuleResolutionError(gtInvoc, null, this.fw);
        }
        if (refObject instanceof ASMFunctionInvocation) {
            ASMFunctionInvocation funInvoc = (ASMFunctionInvocation)refObject;
            return fModelResolver.reportFunInvocResolutionError(funInvoc, null, this.fw);
        }
        if (refObject instanceof RuleUpdateASMFunction) {
            RuleUpdateASMFunction updateRule = (RuleUpdateASMFunction)refObject;
            return fModelResolver.reportAsmFunUpdateResolutionError(updateRule, null, this.fw);
        }
        return null;
    }

    public class MachineDummy
    implements ITreeObject {
        Machine machine;
        String moduleName;
        MachinePropertySource propertySource;

        public MachineDummy(Machine m) {
            this.machine = m;
            this.moduleName = m.getModule() != null ? m.getModule().getName() : "";
        }

        public Machine getMachine() {
            return this.machine;
        }

        @Override
        public FrameworkContainer getFrameworkContainer() {
            return TransformationContent.this.cont;
        }

        @Override
        public Image getLabelImage() {
            return machine_image;
        }

        @Override
        public String getLabelText() {
            String s = "";
            if (TransformationContent.this.xrefman.hasUnresolvedReferences(this.machine.getFqn())) {
                s = " [UNRESOLVED]";
            }
            return String.valueOf(this.machine.getFqn()) + " (" + this.moduleName + ")" + s;
        }

        @Override
        public ITreeParent getParent() {
            return TransformationContent.this;
        }

        @Override
        public IPropertySource2 getPropertySource() {
            if (this.propertySource == null) {
                this.propertySource = new MachinePropertySource(this.machine);
            }
            return this.propertySource;
        }

        @Override
        public Collection<IContributionItem> getContributionItems() {
            return null;
        }

        @Override
        public Collection<IAction> getActions() {
            return TransformationContent.this.actions;
        }

        @Override
        public IAction getDoubleClickAction() {
            return TransformationContent.this.runAction;
        }
    }
}

