/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.dialogs;

import java.util.StringTokenizer;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.frameworkgui.content.transformation.ViatraTreeviewSorter;
import org.eclipse.viatra2.frameworkgui.dialogs.ModelspaceContentProvider;
import org.eclipse.viatra2.frameworkgui.dialogs.ModelspaceLabelProvider;
import org.eclipse.viatra2.frameworkgui.runner.TransformationRunner;

public class ValidatingRunnerInputDialog
extends Dialog {
    private final String message;
    private final String title;
    private Button modelButton;
    private Button runButton;
    protected Label errorMessageLabel;
    private TreeViewer modelSpaceViewer;
    public String[] params;
    public String[] parsed_params;
    private Text valuetext;
    private final WritableValue parameters;
    private DataBindingContext context;
    private final String frameworkId;
    private AggregateValidationStatus aggregateValidationStatus;
    private IChangeListener listener;

    public ValidatingRunnerInputDialog(Shell parentshell, String fwid, String t, String m, String i, String[] p) {
        super(parentshell);
        this.frameworkId = fwid;
        this.title = t;
        this.message = m;
        this.params = p;
        if (Realm.getDefault() == null) {
            SWTObservables.getRealm((Display)Display.getDefault());
        }
        this.parameters = WritableValue.withValueType(String.class);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.runButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.runButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.modelButton = this.createButton(parent, 2, "Select model element", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 16640);
        label.setText(this.message);
        Label label2 = new Label(composite, 16640);
        label2.setText("Hint: use characters [,;] and space to separate parameters.");
        this.errorMessageLabel = new Label(composite, 16640);
        this.errorMessageLabel.setForeground(Display.getDefault().getSystemColor(3));
        GridData _gd = new GridData();
        _gd.widthHint = 400;
        this.errorMessageLabel.setLayoutData((Object)_gd);
        this.errorMessageLabel.setText("No parameters read.");
        this.valuetext = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.widthHint = 513;
        this.valuetext.setLayoutData((Object)gd);
        this.valuetext.setBackground(Display.getDefault().getSystemColor(3));
        try {
            new ContentProposalAdapter((Control)this.valuetext, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new RunContentProposalAdapter(), KeyStroke.getInstance((String)"Ctrl+Space"), null);
        }
        catch (ParseException parseException) {}
        this.modelSpaceViewer = new TreeViewer(composite, 2048);
        GridData gd2 = new GridData();
        gd2.heightHint = 300;
        gd2.widthHint = 500;
        this.modelSpaceViewer.getTree().setLayoutData((Object)gd2);
        this.modelSpaceViewer.setContentProvider((IContentProvider)new ModelspaceContentProvider());
        this.modelSpaceViewer.setLabelProvider((IBaseLabelProvider)new ModelspaceLabelProvider());
        this.modelSpaceViewer.setInput((Object)FrameworkManager.getInstance().getFramework(this.frameworkId));
        this.modelSpaceViewer.setSorter((ViewerSorter)new ViatraTreeviewSorter());
        this.modelSpaceViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                if (a == null && b == null) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                if (a instanceof IModelElement && b instanceof IModelElement) {
                    return a.equals(b);
                }
                return false;
            }

            public int hashCode(Object element) {
                return element == null ? 0 : element.hashCode();
            }
        });
        this.modelSpaceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidatingRunnerInputDialog.this.buttonPressed(2);
            }
        });
        this.context = this.initDataBindings();
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                TransformationRunner.addRunDialogEntry(this.frameworkId, this.valuetext.getText());
                break;
            }
            case 2: {
                this.valuetext.setText(String.valueOf(this.valuetext.getText()) + (this.valuetext.getText().length() > 0 ? "; " : "") + ((IStructuredSelection)this.modelSpaceViewer.getSelection()).getFirstElement().toString());
            }
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        this.defuseDataBindings();
        return super.close();
    }

    protected DataBindingContext initDataBindings() {
        AggregateValidationStatus aggregateValidationStatus;
        ISWTObservableValue value = SWTObservables.observeText((Control)this.valuetext, (int)24);
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)value, (IObservableValue)this.parameters, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ParameterValidator()), null);
        this.aggregateValidationStatus = aggregateValidationStatus = new AggregateValidationStatus((IObservableCollection)bindingContext.getBindings(), 2);
        this.listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                Object value = aggregateValidationStatus.getValue();
                if (value instanceof IStatus) {
                    IStatus status = (IStatus)value;
                    if (status.getSeverity() == 1) {
                        ValidatingRunnerInputDialog.this.runButton.setEnabled(true);
                        ValidatingRunnerInputDialog.this.valuetext.setBackground(Display.getDefault().getSystemColor(1));
                        ValidatingRunnerInputDialog.this.errorMessageLabel.setText("The number of parameters is correct.");
                        ValidatingRunnerInputDialog.this.errorMessageLabel.setForeground(Display.getDefault().getSystemColor(6));
                    } else {
                        ValidatingRunnerInputDialog.this.runButton.setEnabled(false);
                        ValidatingRunnerInputDialog.this.valuetext.setBackground(Display.getDefault().getSystemColor(3));
                        ValidatingRunnerInputDialog.this.errorMessageLabel.setForeground(Display.getDefault().getSystemColor(3));
                        ValidatingRunnerInputDialog.this.errorMessageLabel.setText(status.getMessage());
                    }
                }
            }
        };
        aggregateValidationStatus.addChangeListener(this.listener);
        return bindingContext;
    }

    void defuseDataBindings() {
        this.aggregateValidationStatus.removeChangeListener(this.listener);
    }

    protected class ParameterValidator
    implements IValidator {
        protected ParameterValidator() {
        }

        public IStatus validate(Object value) {
            boolean isValid = false;
            StringTokenizer st = new StringTokenizer((String)value, " ,;");
            boolean bl = isValid = st.countTokens() == ValidatingRunnerInputDialog.this.params.length;
            if (isValid) {
                ValidatingRunnerInputDialog.this.parsed_params = new String[ValidatingRunnerInputDialog.this.params.length];
                int i = 0;
                while (st.hasMoreTokens()) {
                    ValidatingRunnerInputDialog.this.parsed_params[i++] = st.nextToken();
                }
            }
            return isValid ? ValidationStatus.info((String)"") : ValidationStatus.error((String)("Read " + st.countTokens() + " parameters, but expected " + ValidatingRunnerInputDialog.this.params.length + "."));
        }
    }

    private class RunContentProposalAdapter
    implements IContentProposalProvider {
        private RunContentProposalAdapter() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            Object[] entries = TransformationRunner.getRunDialogEntries(ValidatingRunnerInputDialog.this.frameworkId);
            if (entries != null) {
                IContentProposal[] ret = new IContentProposal[entries.length];
                int i = 0;
                while (i < ret.length) {
                    final String entry = (String)TransformationRunner.getRunDialogEntries(ValidatingRunnerInputDialog.this.frameworkId)[ret.length - i - 1];
                    ret[i] = new IContentProposal(){

                        public String getContent() {
                            return entry;
                        }

                        public int getCursorPosition() {
                            return entry.length();
                        }

                        public String getDescription() {
                            return null;
                        }

                        public String getLabel() {
                            return null;
                        }
                    };
                    ++i;
                }
                return ret;
            }
            return new IContentProposal[0];
        }
    }
}

