/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.property;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.content.FrameworkContainer;
import org.eclipse.viatra2.frameworkgui.content.ITreeObject;
import org.eclipse.viatra2.frameworkgui.property.FrameworkGUIPPropertySourceProvider;

public class MultiPropertySheetPage
implements IPropertySheetPage {
    private TabFolder tabFolder;
    private Vector<PropertySheetPage> pages = new Vector();
    private PropertySheetPage singlePage;
    private IFramework viatraFramework;

    public MultiPropertySheetPage(IWorkbenchPart part) {
        this.selectionChanged(part, part.getSite().getSelectionProvider().getSelection());
    }

    public void createControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 1024);
        this.initTabs();
    }

    private void initSinglePage(ITreeObject treeObject) {
        if (this.viatraFramework == null) {
            return;
        }
        for (PropertySheetPage p : this.pages) {
            p.dispose();
        }
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem i = tabItemArray[n2];
            i.dispose();
            ++n2;
        }
        this.pages.clear();
        TabItem item = new TabItem(this.tabFolder, 0);
        this.singlePage = new PropertySheetPage();
        this.singlePage.createControl((Composite)this.tabFolder);
        this.singlePage.setPropertySourceProvider(new IPropertySourceProvider(){

            public IPropertySource getPropertySource(Object object) {
                if (object instanceof ITreeObject) {
                    return ((ITreeObject)object).getPropertySource();
                }
                return null;
            }
        });
        item.setText(treeObject.getLabelText());
        item.setControl(this.singlePage.getControl());
    }

    private void initTabs() {
        if (this.viatraFramework == null) {
            return;
        }
        for (PropertySheetPage p : this.pages) {
            p.dispose();
        }
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem i = tabItemArray[n2];
            i.dispose();
            ++n2;
        }
        this.pages.clear();
        for (String provID : this.viatraFramework.getProperties().getAllProviderIDs()) {
            if (!this.viatraFramework.getProperties().isProviderActive(provID)) continue;
            TabItem item = new TabItem(this.tabFolder, 0);
            PropertySheetPage page = new PropertySheetPage();
            page.createControl((Composite)this.tabFolder);
            page.setPropertySourceProvider((IPropertySourceProvider)new FrameworkGUIPPropertySourceProvider(provID));
            this.pages.add(page);
            item.setText(provID);
            item.setControl(page.getControl());
        }
    }

    public void dispose() {
        this.tabFolder.dispose();
    }

    public Control getControl() {
        return this.tabFolder;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection _s = (IStructuredSelection)selection;
            if (_s.getFirstElement() instanceof FrameworkContainer) {
                this.viatraFramework = ((FrameworkContainer)_s.getFirstElement()).getFramework();
                if (this.tabFolder != null) {
                    this.initTabs();
                    for (PropertySheetPage p : this.pages) {
                        p.selectionChanged(part, selection);
                    }
                }
            } else if (_s.getFirstElement() instanceof ITreeObject) {
                ITreeObject to = (ITreeObject)_s.getFirstElement();
                this.viatraFramework = to.getFrameworkContainer().getFramework();
                if (this.tabFolder != null && to.getPropertySource() != null) {
                    this.initSinglePage(to);
                    this.singlePage.selectionChanged(part, selection);
                }
            }
        }
    }
}

