/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.builtin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.CommandExecutor;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.ParsedCommand;

public class ExecuteCommandScript
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        block13: {
            try {
                if (parameters.size() <= 0) break block13;
                String pURI = parameters.get(0);
                if (pURI.startsWith("/")) {
                    pURI = pURI.substring(1);
                }
                if (!pURI.startsWith("file://")) {
                    pURI = "file://" + pURI;
                } else {
                    String _pURI = pURI.substring(7);
                    if (_pURI.startsWith("/")) {
                        _pURI = _pURI.substring(1);
                        pURI = "file://" + _pURI;
                    }
                }
                URI uri = new URI(pURI);
                String path = String.valueOf(uri.getAuthority()) + uri.getPath();
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.getAuthority());
                NullProgressMonitor mon = new NullProgressMonitor();
                try {
                    if (!p.exists()) {
                        fw.getLogger().error("top-level project " + p.getName() + " does not exist in the workspace");
                        return;
                    }
                    p.open((IProgressMonitor)mon);
                }
                catch (CoreException coreException) {
                    throw new IOException("Target project cannot be created/opened");
                }
                String[] segments = uri.getPath().split("/");
                if (segments.length > 2) {
                    IFolder curr = null;
                    int i = 1;
                    while (i < segments.length - 1) {
                        if (!(curr = curr == null ? p.getFolder(segments[i]) : curr.getFolder(segments[i])).exists()) {
                            fw.getLogger().error("folder " + curr.getName() + " does not exist");
                            return;
                        }
                        ++i;
                    }
                }
                FileReader ret = new FileReader(new File(ifile.getLocation().toOSString()));
                fw.getLogger().info("Executing command script from file " + ifile.getLocation().toPortableString());
                BufferedReader br = new BufferedReader(ret);
                while (br.ready()) {
                    String cmdLine = br.readLine();
                    ParsedCommand cmd = CommandExecutor.getParsedCommand(cmdLine);
                    if (!cmd.isValid) continue;
                    CommandExecutor.executeCommand(fw, cmd);
                }
                ret.close();
                fw.getLogger().info("Execution finished.");
            }
            catch (Throwable t) {
                fw.getLogger().printStackTrace(t);
            }
        }
    }

    @Override
    public String getCommandSignature() {
        return "executecommandscript(workspace_relative_path_to_commandscript_file)";
    }

    @Override
    public String getDescription() {
        return "Executes a VIATRA2 Console command script";
    }

    @Override
    public String getHelpText() {
        return "This command allows you to put a sequence of commands into a line-separated file, load it from the workspace and execute it as a simple macro.";
    }
}

