/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.builtin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.CommandExecutor;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;

public class SaveCommandScript
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        block15: {
            try {
                if (parameters.size() <= 0) break block15;
                String pURI = parameters.get(0);
                if (pURI.startsWith("/")) {
                    pURI = pURI.substring(1);
                }
                if (!pURI.startsWith("file://")) {
                    pURI = "file://" + pURI;
                } else {
                    String _pURI = pURI.substring(7);
                    if (_pURI.startsWith("/")) {
                        _pURI = _pURI.substring(1);
                        pURI = "file://" + _pURI;
                    }
                }
                URI uri = new URI(pURI);
                String path = String.valueOf(uri.getAuthority()) + uri.getPath();
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.getAuthority());
                NullProgressMonitor mon = new NullProgressMonitor();
                try {
                    if (!p.exists()) {
                        p.create((IProgressMonitor)mon);
                    }
                    p.open((IProgressMonitor)mon);
                }
                catch (CoreException coreException) {
                    throw new IOException("Target project cannot be created/opened");
                }
                try {
                    String[] segments = uri.getPath().split("/");
                    if (segments.length > 2) {
                        IFolder curr = null;
                        int i = 1;
                        while (i < segments.length - 1) {
                            if (!(curr = curr == null ? p.getFolder(segments[i]) : curr.getFolder(segments[i])).exists()) {
                                curr.create(true, true, (IProgressMonitor)mon);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException coreException) {
                    throw new IOException("Target folder structure cannot be created");
                }
                fw.getLogger().info("Saving command history to file " + ifile.getLocation().toPortableString());
                FileWriter ret = new FileWriter(new File(ifile.getLocation().toOSString()), true);
                String contents = "";
                for (String raw : CommandExecutor.getCommandHistory(fw)) {
                    contents = String.valueOf(contents) + raw + "\n";
                }
                ret.write(contents);
                ret.close();
                fw.getLogger().info("Saving command history finished.");
            }
            catch (Throwable t) {
                fw.getLogger().printStackTrace(t);
            }
        }
    }

    @Override
    public String getCommandSignature() {
        return "savecommandscript(workspace_relative_path_to_commandscript_file)";
    }

    @Override
    public String getDescription() {
        return "Saves the current command history to a script in the workspace.";
    }

    @Override
    public String getHelpText() {
        return "This command allows you to save the command history as a sequence of commands into a line-separated file macro.";
    }
}

