/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.imports;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.imports.NativeImporterCommands;

public class NativeImportUsing
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        if (parameters.size() != 2) {
            fw.getLogger().error("[NativeImportUsing] Wrong number of parameters supplied. Expected: 2, received: " + parameters.size());
            return;
        }
        String path = parameters.get(0);
        File f = null;
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        f = new File(ifile.getLocation().toOSString());
        if (!f.exists() && !(f = new File(path)).exists()) {
            fw.getLogger().error("[NativeImportUsing] file cannot be located");
            return;
        }
        NativeImporterCommands.commenceImport(fw, f, parameters.get(1));
    }

    @Override
    public String getCommandSignature() {
        return "nativeimportusing(path,importerID)";
    }

    @Override
    public String getDescription() {
        return "Imports the contents of a file into the VIATRA2 model space.";
    }

    @Override
    public String getHelpText() {
        return "Use nativeimportusing(<<fileName>>,<<importerID>>) with workspace-relative pathname (recommended) OR absolute file name, and fully qualified importer ID.\nThis command " + this.getDescription();
    }
}

