/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.wizards.jet.JETGateway;
import org.eclipse.viatra2.frameworkgui.wizards.model.FileTemplateExtension;
import org.eclipse.viatra2.frameworkgui.wizards.ui.TemplateSelectionPage;
import org.eclipse.viatra2.frameworkgui.wizards.ui.VIATRANewFileCreationPage;

public abstract class NewVIATRAWizard
extends Wizard
implements INewWizard {
    String iKind;
    protected IStructuredSelection iSelection;
    private IWorkbench mWorkbench;
    protected VIATRANewFileCreationPage iMainPage;
    protected TemplateSelectionPage iSelectionPage;
    IFile newFile;

    public NewVIATRAWizard(String aKind) {
        this.iKind = aKind;
    }

    public boolean canFinish() {
        if (this.iMainPage != null) {
            return this.iMainPage.isPageComplete();
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.iSelection = selection;
        this.mWorkbench = workbench;
        this.setWindowTitle("Create a new VIATRA2 " + this.iKind.toUpperCase() + " file");
    }

    public void addPages() {
        this.iMainPage = new VIATRANewFileCreationPage(this.iKind, this.iSelection);
        this.addPage((IWizardPage)this.iMainPage);
        this.iSelectionPage = new TemplateSelectionPage(this.iKind);
        this.addPage((IWizardPage)this.iSelectionPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.newFile != null) {
            if (this.iSelectionPage.getSelectedTemplate() != null) {
                FileTemplateExtension template = this.iSelectionPage.getSelectedTemplate();
                JETGateway gw = new JETGateway(template);
                try {
                    String result = gw.generate(monitor);
                    gw.save(this.newFile, monitor, result.getBytes());
                    ResourcesPlugin.getWorkspace().getRoot().getProject(".JETEmitters").delete(true, true, monitor);
                }
                catch (JETException e) {
                    FrameworkGUIPlugin.log(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.selectAndReveal((IResource)this.newFile);
            this.openResource((IResource)this.newFile);
        }
    }

    public boolean performFinish() {
        if (!this.iMainPage.isPageComplete()) {
            return false;
        }
        String basefn = this.iMainPage.getFileName();
        if (!basefn.endsWith("." + this.iKind.toLowerCase())) {
            this.iMainPage.setFileName(String.valueOf(basefn) + "." + this.iKind.toLowerCase());
        }
        this.newFile = this.iMainPage.createNewFile();
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    NewVIATRAWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String exceptionMessage = "Error while generating the VIATRA2 file.";
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            exceptionMessage = e.getCause().getMessage();
        } else if (e.getMessage() != null) {
            exceptionMessage = e.getMessage();
        }
        Status status = new Status(4, FrameworkGUIPlugin.getPluginId(), 4, exceptionMessage, (Throwable)e);
        FrameworkGUIPlugin.log((IStatus)status);
        String title = "Error";
        String message = "Error happened while invoking the JET engine.";
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = FrameworkGUIPlugin.getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        FrameworkGUIPlugin.log(e);
                    }
                }
            });
        }
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.mWorkbench.getActiveWorkbenchWindow());
    }

    private static class WorkbenchRunnableAdapter
    implements IRunnableWithProgress {
        private IWorkspaceRunnable fWorkspaceRunnable;

        public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
            this.fWorkspaceRunnable = runnable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                ResourcesPlugin.getWorkspace().run(this.fWorkspaceRunnable, monitor);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

