/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.wizards.jet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.viatra2.frameworkgui.wizards.model.FileTemplateExtension;

public class JETGateway {
    private FileTemplateExtension template = null;

    public JETGateway(FileTemplateExtension t) {
        this.template = t;
    }

    public String generate(IProgressMonitor monitor) throws CoreException, JETException {
        monitor = this.createIfNull(monitor);
        String pluginId = this.template.contributorID;
        String base = Platform.getBundle((String)pluginId).getEntry("/").toString();
        String relativeUri = this.template.templateFile;
        JETEmitter emitter = new JETEmitter(String.valueOf(base) + relativeUri, this.getClass().getClassLoader());
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        try {
            String result = emitter.generate((IProgressMonitor)sub, new Object[]{this.template.getParameterMap()});
            monitor.worked(1);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void save(IFile targetFile, IProgressMonitor monitor, byte[] contents) throws CoreException {
        monitor = this.createIfNull(monitor);
        ByteArrayInputStream newContents = new ByteArrayInputStream(contents);
        if (targetFile.exists()) {
            targetFile.setContents((InputStream)newContents, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            targetFile.create((InputStream)newContents, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private IProgressMonitor createIfNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }
}

